/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.OrderedResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomResolver
implements OrderedResolver {
    private static final Logger LOG = LoggerFactory.getLogger(RandomResolver.class);
    private static final Random RANDOM = new Random();

    @Override
    public String getFirstNamespace(String path, PathLocation loc) {
        if (loc == null) {
            return null;
        }
        Set<String> namespaces = loc.getNamespaces();
        if (namespaces == null || namespaces.isEmpty()) {
            LOG.error("Cannot get namespaces for {}", (Object)loc);
            return null;
        }
        ArrayList<String> nssList = new ArrayList<String>(namespaces);
        int index = RANDOM.nextInt(nssList.size());
        return (String)nssList.get(index);
    }
}

