/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.List;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class DeploymentOptions {
    public static final ConfigOption<String> TARGET = ConfigOptions.key("execution.target").stringType().noDefaultValue().withDescription(Description.builder().text("The deployment target for the execution. This can take one of the following values when calling %s:", TextElement.code("bin/flink run")).list(TextElement.text("remote"), TextElement.text("local"), TextElement.text("yarn-per-job (deprecated)"), TextElement.text("yarn-session"), TextElement.text("kubernetes-session")).text("And one of the following values when calling %s:", TextElement.code("bin/flink run-application")).list(TextElement.text("yarn-application"), TextElement.text("kubernetes-application")).build());
    public static final ConfigOption<Boolean> ATTACHED = ConfigOptions.key("execution.attached").booleanType().defaultValue(false).withDescription("Specifies if the pipeline is submitted in attached or detached mode.");
    public static final ConfigOption<Boolean> SHUTDOWN_IF_ATTACHED = ConfigOptions.key("execution.shutdown-on-attached-exit").booleanType().defaultValue(false).withDescription("If the job is submitted in attached mode, perform a best-effort cluster shutdown when the CLI is terminated abruptly, e.g., in response to a user interrupt, such as typing Ctrl + C.");
    public static final ConfigOption<List<String>> JOB_LISTENERS = ConfigOptions.key("execution.job-listeners").stringType().asList().noDefaultValue().withDescription("Custom JobListeners to be registered with the execution environment. The registered listeners cannot have constructors with arguments.");
    public static final ConfigOption<Boolean> SHUTDOWN_ON_APPLICATION_FINISH = ConfigOptions.key("execution.shutdown-on-application-finish").booleanType().defaultValue(true).withDescription("Whether a Flink Application cluster should shut down automatically after its application finishes (either successfully or as result of a failure). Has no effect for other deployment modes.");
    @Experimental
    public static final ConfigOption<Boolean> SUBMIT_FAILED_JOB_ON_APPLICATION_ERROR = ConfigOptions.key("execution.submit-failed-job-on-application-error").booleanType().defaultValue(false).withDescription(Description.builder().text("If a failed job should be submitted (in the application mode) when there is an error in the application driver before an actual job submission. This is intended for providing a clean way of reporting failures back to the user and is especially useful in combination with '%s'. This option only works when the single job submission is enforced ('%s' is enabled). Please note that this is an experimental option and may be changed in the future.", TextElement.text(SHUTDOWN_ON_APPLICATION_FINISH.key()), TextElement.text(HighAvailabilityOptions.HA_MODE.key())).build());
    @Experimental
    public static final ConfigOption<List<String>> PROGRAM_CONFIG_WILDCARDS = ConfigOptions.key("execution.program-config.wildcards").stringType().asList().defaultValues((String[])new String[0]).withDescription(Description.builder().text("List of configuration keys that are allowed to be set in a user program regardless whether program configuration is enabled or not.").linebreak().linebreak().text("Currently, this list is limited to '%s' only.", TextElement.text(PipelineOptions.GLOBAL_JOB_PARAMETERS.key())).build());
    @Experimental
    public static final ConfigOption<Boolean> PROGRAM_CONFIG_ENABLED = ConfigOptions.key("execution.program-config.enabled").booleanType().defaultValue(true).withDeprecatedKeys("execution.allow-client-job-configurations").withDescription(Description.builder().text("Determines whether configurations in the user program are allowed. By default, configuration can be set both on a cluster-level (via options) or within the user program (i.e. programmatic via environment setters). If disabled, all configuration must be defined on a cluster-level and programmatic setters in the user program are prohibited.").linebreak().linebreak().text("Depending on your deployment mode failing the job might have different implications. Either your client that is trying to submit the job to an external cluster (session cluster deployment) throws the exception or the job manager (application mode deployment).").linebreak().linebreak().text("The '%s' option lists configuration keys that are allowed to be set in user programs regardless of this setting.", TextElement.text(PROGRAM_CONFIG_WILDCARDS.key())).build());
}

