/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import java.util.Optional;
import org.apache.flink.runtime.rest.handler.router.RouteResult;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.QueryStringDecoder;
import org.apache.flink.shaded.netty4.io.netty.util.ReferenceCountUtil;
import org.apache.flink.shaded.netty4.io.netty.util.ReferenceCounted;
import org.apache.flink.util.Preconditions;

public class RoutedRequest<T>
implements ReferenceCounted {
    private final RouteResult<T> result;
    private final HttpRequest request;
    private final Optional<ReferenceCounted> requestAsReferenceCounted;
    private final QueryStringDecoder queryStringDecoder;

    public RoutedRequest(RouteResult<T> result, HttpRequest request) {
        this.result = Preconditions.checkNotNull(result);
        this.request = Preconditions.checkNotNull(request);
        this.requestAsReferenceCounted = Optional.ofNullable(request instanceof ReferenceCounted ? (ReferenceCounted)request : null);
        this.queryStringDecoder = new QueryStringDecoder(request.uri());
    }

    public RouteResult<T> getRouteResult() {
        return this.result;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public String getPath() {
        return this.queryStringDecoder.path();
    }

    public int refCnt() {
        if (this.requestAsReferenceCounted.isPresent()) {
            return this.requestAsReferenceCounted.get().refCnt();
        }
        return 0;
    }

    public boolean release() {
        if (this.requestAsReferenceCounted.isPresent()) {
            return this.requestAsReferenceCounted.get().release();
        }
        return true;
    }

    public boolean release(int arg0) {
        if (this.requestAsReferenceCounted.isPresent()) {
            return this.requestAsReferenceCounted.get().release(arg0);
        }
        return true;
    }

    public ReferenceCounted retain() {
        if (this.requestAsReferenceCounted.isPresent()) {
            this.requestAsReferenceCounted.get().retain();
        }
        return this;
    }

    public ReferenceCounted retain(int arg0) {
        if (this.requestAsReferenceCounted.isPresent()) {
            this.requestAsReferenceCounted.get().retain(arg0);
        }
        return this;
    }

    public ReferenceCounted touch() {
        if (this.requestAsReferenceCounted.isPresent()) {
            ReferenceCountUtil.touch((Object)this.requestAsReferenceCounted.get());
        }
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        if (this.requestAsReferenceCounted.isPresent()) {
            ReferenceCountUtil.touch((Object)this.requestAsReferenceCounted.get(), (Object)hint);
        }
        return this;
    }
}

