/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.LocalRecoveryDirectoryProvider;

public class LocalRecoveryConfig {
    @Nullable
    private final LocalRecoveryDirectoryProvider localStateDirectories;

    public LocalRecoveryConfig(@Nullable LocalRecoveryDirectoryProvider directoryProvider) {
        this.localStateDirectories = directoryProvider;
    }

    public boolean isLocalRecoveryEnabled() {
        return this.localStateDirectories != null;
    }

    public Optional<LocalRecoveryDirectoryProvider> getLocalStateDirectoryProvider() {
        return Optional.ofNullable(this.localStateDirectories);
    }

    public String toString() {
        return "LocalRecoveryConfig{localStateDirectories=" + this.localStateDirectories + '}';
    }

    public static Supplier<IllegalStateException> localRecoveryNotEnabled() {
        return () -> new IllegalStateException("Getting a LocalRecoveryDirectoryProvider is only supported with the local recovery enabled. This is a bug and should be reported.");
    }
}

