/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.store.connector.source.ContinuousFileStoreSource;
import org.apache.flink.table.store.connector.source.FlinkSource;
import org.apache.flink.table.store.connector.source.FlinkTableSource;
import org.apache.flink.table.store.connector.source.SimpleSystemSource;
import org.apache.flink.table.store.connector.source.StaticFileStoreSource;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.table.DataTable;
import org.apache.flink.table.store.table.Table;

public class SystemTableSource
extends FlinkTableSource {
    private final Table table;
    private final boolean isStreamingMode;

    public SystemTableSource(Table table, boolean isStreamingMode) {
        super(table);
        this.table = table;
        this.isStreamingMode = isStreamingMode;
    }

    public SystemTableSource(Table table, boolean isStreamingMode, @Nullable Predicate predicate, @Nullable int[][] projectFields, @Nullable Long limit) {
        super(table, predicate, projectFields, limit);
        this.table = table;
        this.isStreamingMode = isStreamingMode;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        FlinkSource source;
        if (this.table instanceof DataTable) {
            DataTable dataTable = (DataTable)this.table;
            source = this.isStreamingMode ? new ContinuousFileStoreSource(dataTable, this.projectFields, this.predicate, this.limit) : new StaticFileStoreSource(dataTable, this.projectFields, this.predicate, this.limit);
        } else {
            source = new SimpleSystemSource(this.table, this.projectFields, this.predicate, this.limit);
        }
        return SourceProvider.of((Source)source);
    }

    public DynamicTableSource copy() {
        return new SystemTableSource(this.table, this.isStreamingMode, this.predicate, this.projectFields, this.limit);
    }

    public String asSummaryString() {
        return "TableStore-SystemTable-Source";
    }
}

