/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.scopes;

import java.util.Set;
import org.apache.flex.compiler.definitions.INamespaceDefinition;
import org.apache.flex.compiler.internal.caches.PackageNamespaceDefinitionCache;
import org.apache.flex.compiler.internal.definitions.ScopedDefinitionBase;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.scopes.ASFileScope;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.scopes.MXMLFileScope;
import org.apache.flex.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.flex.compiler.internal.workspaces.Workspace;

public final class PackageScope
extends ASScope {
    private final INamespaceDefinition.ILanguageNamespaceDefinition internalNamespaceReference;
    private final INamespaceDefinition.ILanguageNamespaceDefinition publicNamespaceReference;

    public PackageScope(ASScope containingScope, String packageName) {
        this(containingScope, packageName, null);
    }

    public PackageScope(ASScope containingScope, String packageName, ScopedBlockNode contentsNode) {
        super(containingScope, contentsNode);
        Workspace workspace = (Workspace)containingScope.getWorkspace();
        PackageNamespaceDefinitionCache packageNSCache = workspace.getPackageNamespaceDefinitionCache();
        this.internalNamespaceReference = packageNSCache.get(packageName, true);
        this.publicNamespaceReference = packageNSCache.get(packageName, false);
        if (containingScope instanceof ASFileScope) {
            for (String s : ASFileScope.getImplicitImportsForAS()) {
                this.addImport(s);
            }
        }
    }

    public INamespaceDefinition.ILanguageNamespaceDefinition getInternalNamespace() {
        return this.internalNamespaceReference;
    }

    public INamespaceDefinition.ILanguageNamespaceDefinition getPublicNamespace() {
        return this.publicNamespaceReference;
    }

    @Override
    public void addImplicitOpenNamespaces(CompilerProject compilerProject, Set<INamespaceDefinition> result) {
        result.add(this.getPublicNamespace());
        result.add(this.getInternalNamespace());
    }

    @Override
    public ScopedDefinitionBase getContainingDefinition() {
        return null;
    }

    @Override
    protected void addNamespacesFromContainingScope(CompilerProject compilerProject, Set<INamespaceDefinition> result) {
        ASScope containingScope = this.getContainingScope();
        if (containingScope != null) {
            if (!(containingScope instanceof MXMLFileScope)) {
                containingScope.addImplicitOpenNamespaces(compilerProject, result);
            } else {
                result.addAll(containingScope.getNamespaceSet(compilerProject));
            }
        }
    }

    @Override
    protected void getContainingScopeExplicitImports(CompilerProject project, String name, Set<INamespaceDefinition> nsSet) {
        ASScope containingScope = this.getContainingScope();
        if (containingScope instanceof MXMLFileScope) {
            nsSet.addAll(containingScope.getExplicitImportQualifiers(project, name));
        }
    }
}

