/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.OptimizerConstants;
import adobe.abc.Symtab;
import adobe.abc.Type;
import adobe.abc.Typeref;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeCache {
    public Type OBJECT;
    public Type FUNCTION;
    public Type CLASS;
    public Type ARRAY;
    public Type INT;
    public Type UINT;
    public Type NUMBER;
    public Type BOOLEAN;
    public Type STRING;
    public Type NAMESPACE;
    public Type XML;
    public Type XMLLIST;
    public Type QNAME;
    public Type NULL;
    public Type VOID;
    public Type ANY;
    public Set<Type> builtinTypes = new HashSet<Type>();
    public Set<Type> baseTypes = new HashSet<Type>();
    public Symtab<Type> namedTypes = new Symtab();
    public Symtab<Typeref> globals = new Symtab();
    public Map<Namespace, Name> namespaceNames = new HashMap<Namespace, Name>();
    private static TypeCache the_instance = new TypeCache();

    public static TypeCache instance() {
        return the_instance;
    }

    public Type ANY() {
        if (null == this.ANY) {
            this.ANY = new Type(new Name("*"), null);
            this.ANY.ctype = 1;
        }
        return this.ANY;
    }

    Type lookup(Name n, Type base) {
        Name n2;
        Type t = this.namedTypes.get(n);
        if (t == null && (t = this.namedTypes.get(n2 = new Name(7, new Namespace(22, ""), n.name))) == null) {
            t = new Type(n2, base);
            TypeCache.instance().namedTypes.put(n2, t);
        }
        return t;
    }

    Type lookup(String name, Type base) {
        return this.lookup(new Name(name), base);
    }

    Type lookup(String name) {
        return this.lookup(name, this.OBJECT);
    }

    void setupBuiltins() {
        assert (null == this.OBJECT);
        this.OBJECT = this.namedTypes.get(new Name(Name.PKG_PUBLIC, "Object"));
        assert (null != this.OBJECT);
        this.NULL = this.lookup("null");
        this.CLASS = this.lookup("Class");
        this.FUNCTION = this.lookup("Function");
        this.ARRAY = this.lookup("Array");
        this.INT = this.lookup("int");
        this.UINT = this.lookup("uint");
        this.NUMBER = this.lookup("Number");
        this.BOOLEAN = this.lookup("Boolean");
        this.STRING = this.lookup("String");
        this.NAMESPACE = this.lookup("Namespace");
        this.XML = this.lookup("XML");
        this.XMLLIST = this.lookup("XMLList");
        this.QNAME = this.lookup("QName");
        this.VOID = this.lookup("void", null);
        this.OBJECT.ctype = 1;
        this.NULL.ctype = 1;
        this.VOID.ctype = 0;
        this.INT.ctype = 3;
        this.UINT.ctype = 4;
        this.NUMBER.ctype = 5;
        this.BOOLEAN.ctype = 2;
        this.STRING.ctype = 6;
        this.NAMESPACE.ctype = 7;
        this.BOOLEAN.numeric = true;
        this.UINT.numeric = true;
        this.NUMBER.numeric = true;
        this.INT.numeric = true;
        this.BOOLEAN.primitive = true;
        this.STRING.primitive = true;
        this.UINT.primitive = true;
        this.NUMBER.primitive = true;
        this.INT.primitive = true;
        this.NULL.primitive = true;
        this.VOID.primitive = true;
        this.VOID.atom = true;
        this.OBJECT.atom = true;
        this.ANY.atom = true;
        this.INT.ref = this.INT.ref.nonnull();
        this.NUMBER.ref = this.NUMBER.ref.nonnull();
        this.UINT.ref = this.UINT.ref.nonnull();
        this.BOOLEAN.ref = this.BOOLEAN.ref.nonnull();
        this.OBJECT.defaultValue = this.NULL;
        this.NULL.defaultValue = this.NULL;
        this.ANY.defaultValue = OptimizerConstants.UNDEFINED;
        this.VOID.defaultValue = OptimizerConstants.UNDEFINED;
        this.BOOLEAN.defaultValue = Boolean.FALSE;
        this.NUMBER.defaultValue = OptimizerConstants.NAN;
        this.INT.defaultValue = 0;
        this.UINT.defaultValue = 0;
        this.builtinTypes.add(this.CLASS);
        this.builtinTypes.add(this.FUNCTION);
        this.builtinTypes.add(this.ARRAY);
        this.builtinTypes.add(this.INT);
        this.builtinTypes.add(this.UINT);
        this.builtinTypes.add(this.NUMBER);
        this.builtinTypes.add(this.BOOLEAN);
        this.builtinTypes.add(this.STRING);
        this.builtinTypes.add(this.NAMESPACE);
        this.builtinTypes.add(this.XML);
        this.builtinTypes.add(this.XMLLIST);
        this.builtinTypes.add(this.QNAME);
        this.builtinTypes.add(this.VOID);
    }

    public boolean containsNamedType(Type at) {
        return this.containsNamedType(at.getName());
    }

    public boolean containsNamedType(Name n) {
        return this.namedTypes.contains(n);
    }
}

