/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;

public final class NetUtils {
    public static final String LOOPBACK_ADDRESS_V4 = "127.0.0.1";
    private static final HostAndPortFactory<InetSocketAddress> inetSocketAddressFactory = new HostAndPortFactory<InetSocketAddress>(){

        @Override
        public InetSocketAddress newInstance(String host, int port) {
            if (!HostAndPort.isValidPort(port)) {
                return null;
            }
            return new InetSocketAddress(host, port);
        }
    };

    private NetUtils() {
    }

    public static List<InetSocketAddress> toInetSocketAddressList(List<String> addressList) {
        return NetUtils.toHostAndPortList(addressList, inetSocketAddressFactory);
    }

    public static <T> List<T> toHostAndPortList(List<String> addressList, HostAndPortFactory<T> hostAndPortFactory) {
        if (CollectionUtils.isEmpty(addressList)) {
            return Collections.emptyList();
        }
        ArrayList<T> hostAndPortList = new ArrayList<T>(addressList.size());
        for (String address : addressList) {
            T hostAndPort = NetUtils.parseHostAndPort(address, hostAndPortFactory);
            if (hostAndPort == null) continue;
            hostAndPortList.add(hostAndPort);
        }
        return hostAndPortList;
    }

    public static InetSocketAddress toInetSocketAddress(String address) {
        return NetUtils.parseHostAndPort(address, inetSocketAddressFactory);
    }

    public static <T> T parseHostAndPort(String address, HostAndPortFactory<T> hostAndPortFactory) {
        if (StringUtils.isEmpty(address)) {
            return null;
        }
        Objects.requireNonNull(hostAndPortFactory, "hostAndPortFactory");
        int hostIndex = address.indexOf(58);
        if (hostIndex == -1) {
            return null;
        }
        String host = address.substring(0, hostIndex);
        String portString = address.substring(hostIndex + 1);
        int port = NetUtils.parseInteger(portString, -1);
        return hostAndPortFactory.newInstance(host, port);
    }

    private static int parseInteger(String str, int defaultInt) {
        if (str == null) {
            return defaultInt;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultInt;
        }
    }

    public static String getLocalV4Ip() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String localIp = localHost.getHostAddress();
            if (NetUtils.validationIpV4FormatAddress(localIp)) {
                return localIp;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return LOOPBACK_ADDRESS_V4;
    }

    public static List<String> getLocalV4IpList() {
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (interfaces == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (NetUtils.isSkipIp(current)) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || !(address instanceof Inet4Address) || !NetUtils.validationIpV4FormatAddress(address.getHostAddress())) continue;
                result.add(address.getHostAddress());
            }
        }
        return result;
    }

    private static boolean isSkipIp(NetworkInterface networkInterface) {
        try {
            return !networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean validationIpPortV4FormatAddress(String address) {
        int splitIndex = address.indexOf(58);
        if (splitIndex == -1 || splitIndex + 1 >= address.length()) {
            return false;
        }
        String ip = address.substring(0, splitIndex);
        if (!NetUtils.validationIpV4FormatAddress(ip)) {
            return false;
        }
        String portString = address.substring(splitIndex + 1);
        int port = NetUtils.parseInteger(portString, -1);
        return HostAndPort.isValidPort(port);
    }

    public static boolean validationIpV4FormatAddress(String address) {
        try {
            String[] eachDotAddress = address.split("\\.");
            if (eachDotAddress.length != 4) {
                return false;
            }
            for (String eachAddress : eachDotAddress) {
                if (Integer.parseInt(eachAddress) <= 255) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static interface HostAndPortFactory<T> {
        public T newInstance(String var1, int var2);
    }
}

