/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.utils;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudEventUtils.class);

    public static SendResult convertSendResult(org.apache.rocketmq.client.producer.SendResult rmqResult) {
        SendResult sendResult = new SendResult();
        sendResult.setTopic(rmqResult.getMessageQueue().getTopic());
        sendResult.setMessageId(rmqResult.getMsgId());
        return sendResult;
    }

    public static Message msgConvert(MessageExt rmqMsg) {
        Message message = new Message();
        CloudEventUtils.initProperty(rmqMsg, message, Message::getTopic, Message::setTopic);
        CloudEventUtils.initProperty(rmqMsg, message, Message::getKeys, Message::setKeys);
        CloudEventUtils.initProperty(rmqMsg, message, Message::getTags, Message::setTags);
        if (rmqMsg.getBody() != null) {
            message.setBody(rmqMsg.getBody());
        }
        rmqMsg.getProperties().forEach((k, v) -> MessageAccessor.putProperty((Message)message, (String)k, (String)v));
        if (rmqMsg.getMsgId() != null) {
            MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("messageid"), (String)rmqMsg.getMsgId());
        }
        if (rmqMsg.getTopic() != null) {
            MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("destination"), (String)rmqMsg.getTopic());
        }
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("bornhost"), (String)String.valueOf(rmqMsg.getBornHost()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("borntimestamp"), (String)String.valueOf(rmqMsg.getBornTimestamp()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("storehost"), (String)String.valueOf(rmqMsg.getStoreHost()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("storetimestamp"), (String)String.valueOf(rmqMsg.getStoreTimestamp()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("queueid"), (String)String.valueOf(rmqMsg.getQueueId()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("queueoffset"), (String)String.valueOf(rmqMsg.getQueueOffset()));
        for (String sysPropKey : MessageConst.STRING_HASH_SET) {
            if (!StringUtils.isNotEmpty((CharSequence)message.getProperty(sysPropKey))) continue;
            String prop = message.getProperty(sysPropKey);
            String tmpPropKey = sysPropKey.toLowerCase().replaceAll("_", "99");
            MessageAccessor.putProperty((Message)message, (String)tmpPropKey, (String)prop);
            message.getProperties().remove(sysPropKey);
        }
        return message;
    }

    private static String buildCloudEventPropertyKey(String propName) {
        return propName;
    }

    public static MessageExt msgConvertExt(Message message) {
        MessageExt rmqMessageExt = new MessageExt();
        try {
            CloudEventUtils.initProperty(message, rmqMessageExt, Message::getKeys, Message::setKeys);
            CloudEventUtils.initProperty(message, rmqMessageExt, Message::getTags, Message::setTags);
            if (message.getBody() != null) {
                rmqMessageExt.setBody(message.getBody());
            }
            rmqMessageExt.setTopic(message.getTopic());
            int queueId = Integer.parseInt(message.getProperty(CloudEventUtils.buildCloudEventPropertyKey("queueid")));
            long queueOffset = Long.parseLong(message.getProperty(CloudEventUtils.buildCloudEventPropertyKey("queueoffset")));
            rmqMessageExt.setQueueId(queueId);
            rmqMessageExt.setQueueOffset(queueOffset);
            message.getProperties().forEach((k, v) -> MessageAccessor.putProperty((Message)rmqMessageExt, (String)k, (String)v));
        }
        catch (Exception e) {
            LOGGER.error("Error with msgConvertExt", (Throwable)e);
            e.printStackTrace();
        }
        return rmqMessageExt;
    }

    private static <T, V> void initProperty(T source, V target, Function<T, String> function, BiConsumer<V, String> biConsumer) {
        String apply = function.apply(source);
        if (Objects.nonNull(apply)) {
            biConsumer.accept(target, apply);
        }
    }
}

