/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorsLoggingHandler
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorsLoggingHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String message;
        if (cause instanceof IOException && IGNORABLE_ERROR_MESSAGE.matcher(message = String.valueOf(cause.getMessage()).toLowerCase()).matches()) {
            return;
        }
        log.error("Exception occured. Channel: " + ctx.channel(), cause);
    }
}

