/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.stream;

import java.util.Map;
import org.redisson.api.stream.BaseStreamTrimArgs;
import org.redisson.api.stream.StreamAddArgs;
import org.redisson.api.stream.StreamAddArgsSource;
import org.redisson.api.stream.StreamAddParams;
import org.redisson.api.stream.StreamTrimStrategyArgs;
import org.redisson.api.stream.TrimStrategy;

class BaseStreamAddArgs<K, V>
implements StreamAddArgs<K, V>,
StreamAddArgsSource<K, V> {
    private final StreamAddParams<K, V> params;

    BaseStreamAddArgs(Map<K, V> entries) {
        this.params = new StreamAddParams<K, V>(entries);
    }

    @Override
    public StreamAddParams<K, V> getParams() {
        return this.params;
    }

    @Override
    public StreamAddArgs<K, V> noMakeStream() {
        this.params.setNoMakeStream(true);
        return this;
    }

    @Override
    public StreamAddArgs<K, V> trim(TrimStrategy strategy, int threshold) {
        return this.trim(strategy, threshold, 0);
    }

    @Override
    public StreamAddArgs<K, V> trimStrict(TrimStrategy strategy, int threshold) {
        this.params.setMaxLen(threshold);
        this.params.setTrimStrict(true);
        return this;
    }

    @Override
    public StreamAddArgs<K, V> trim(TrimStrategy strategy, int threshold, int limit) {
        this.params.setMaxLen(threshold);
        this.params.setTrimStrict(false);
        this.params.setLimit(limit);
        return this;
    }

    @Override
    public StreamTrimStrategyArgs<StreamAddArgs<K, V>> trim() {
        this.params.setTrimStrict(true);
        return new BaseStreamTrimArgs<StreamAddArgs<K, V>>(this.params, this);
    }

    @Override
    public StreamTrimStrategyArgs<StreamAddArgs<K, V>> trimNonStrict() {
        return new BaseStreamTrimArgs<StreamAddArgs<K, V>>(this.params, this);
    }
}

