/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.knative.consumer;

import com.google.common.collect.Lists;
import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.connector.knative.consumer.DefaultConsumer;
import org.apache.eventmesh.connector.knative.patch.EventMeshConsumeConcurrentlyContext;
import org.apache.eventmesh.connector.knative.patch.EventMeshConsumeConcurrentlyStatus;
import org.apache.eventmesh.connector.knative.patch.EventMeshMessageListenerConcurrently;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullConsumerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(PullConsumerImpl.class);
    private final transient DefaultConsumer defaultConsumer;
    private transient List<SubscriptionItem> topicList = null;
    private final transient ConcurrentHashMap<String, AtomicLong> offsetMap;
    private final transient AtomicBoolean started = new AtomicBoolean(false);
    private final transient Properties properties;
    private transient ConcurrentMap<String, String> subscriptionInner;
    private transient EventListener eventListener;

    public PullConsumerImpl(Properties properties) throws Exception {
        this.properties = properties;
        this.topicList = Lists.newArrayList();
        this.subscriptionInner = new ConcurrentHashMap<String, String>();
        this.offsetMap = new ConcurrentHashMap();
        this.defaultConsumer = new DefaultConsumer();
        this.defaultConsumer.registerMessageListener(new ClusteringMessageListener());
    }

    public void subscribe(String topic) {
        try {
            this.topicList.add(new SubscriptionItem(topic, SubscriptionMode.CLUSTERING, SubscriptionType.ASYNC));
            this.topicList.forEach(item -> {
                try {
                    this.subscriptionInner.put(item.getTopic(), this.defaultConsumer.pullMessage(item.getTopic(), this.properties.getProperty("serviceAddr")));
                }
                catch (Exception e) {
                    LOG.error("store received message error", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            LOG.error("other error", (Throwable)e);
        }
    }

    public void unsubscribe(String topic) {
        try {
            this.topicList.remove(topic);
        }
        catch (Exception e) {
            LOG.error("unsubscribe topic error", (Throwable)e);
        }
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        cloudEvents.forEach(cloudEvent -> this.updateOffset(cloudEvent.getSubject(), (Long)cloudEvent.getExtension("offset")));
    }

    public void updateOffset(String topicMetadata, Long offset) {
        this.offsetMap.computeIfPresent(topicMetadata, (k, v) -> {
            v.set(offset);
            return v;
        });
    }

    public void start() {
        this.started.set(true);
    }

    public synchronized void shutdown() {
        this.started.set(false);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void registerEventListener(EventListener listener) {
        this.eventListener = listener;
    }

    private class ClusteringMessageListener
    extends EventMeshMessageListenerConcurrently {
        private ClusteringMessageListener() {
        }

        @Override
        public EventMeshConsumeConcurrentlyStatus handleMessage(CloudEvent cloudEvent, EventMeshConsumeConcurrentlyContext context) {
            final Properties contextProperties = new Properties();
            contextProperties.put("em.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
            EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = new EventMeshAsyncConsumeContext(){

                public void commit(EventMeshAction action) {
                    switch (action) {
                        case CommitMessage: {
                            contextProperties.put("em.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_SUCCESS.name());
                            break;
                        }
                        case ReconsumeLater: {
                            contextProperties.put("em.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
                            break;
                        }
                        case ManualAck: {
                            contextProperties.put("em.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_FINISH.name());
                            break;
                        }
                    }
                }
            };
            eventMeshAsyncConsumeContext.setAbstractContext((AbstractContext)context);
            PullConsumerImpl.this.eventListener.consume(cloudEvent, (AsyncConsumeContext)eventMeshAsyncConsumeContext);
            return EventMeshConsumeConcurrentlyStatus.valueOf(contextProperties.getProperty("em.message.consume.status"));
        }
    }
}

