/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.knative.consumer;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.connector.knative.config.ClientConfiguration;
import org.apache.eventmesh.connector.knative.consumer.PullConsumerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnativeConsumerImpl
implements Consumer {
    private static final Logger LOG = LoggerFactory.getLogger(KnativeConsumerImpl.class);
    private transient PullConsumerImpl pullConsumer;

    public synchronized void init(Properties properties) throws Exception {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.init();
        properties.put("emUrl", clientConfiguration.getEmurl());
        properties.put("serviceAddr", clientConfiguration.getServiceAddr());
        this.pullConsumer = new PullConsumerImpl(properties);
    }

    public void subscribe(String topic) {
        this.pullConsumer.subscribe(topic);
    }

    public void unsubscribe(String topic) {
        try {
            this.pullConsumer.unsubscribe(topic);
        }
        catch (Exception e) {
            LOG.error("unsubscribe error", (Throwable)e);
        }
    }

    public void registerEventListener(EventListener listener) {
        this.pullConsumer.registerEventListener(listener);
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        this.pullConsumer.updateOffset(cloudEvents, context);
    }

    public boolean isStarted() {
        return this.pullConsumer.isStarted();
    }

    public boolean isClosed() {
        return this.pullConsumer.isClosed();
    }

    public void start() {
        this.pullConsumer.start();
    }

    public void shutdown() {
        this.pullConsumer.shutdown();
    }
}

