/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.knative.consumer;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.connector.knative.patch.EventMeshMessageListenerConcurrently;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.util.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumer {
    private static final Logger log = LoggerFactory.getLogger(DefaultConsumer.class);
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConsumer.class);
    private transient AsyncHttpClient asyncHttpClient = Dsl.asyncHttpClient();
    private transient EventMeshMessageListenerConcurrently messageListener;

    public EventMeshMessageListenerConcurrently getMessageListener() {
        return this.messageListener;
    }

    public String pullMessage(String topic, String subscribeUrl) throws Exception {
        Preconditions.checkNotNull((Object)topic, (Object)"Subscribe item cannot be null");
        Preconditions.checkNotNull((Object)subscribeUrl, (Object)"SubscribeUrl cannot be null");
        ListenableFuture execute = this.asyncHttpClient.prepareGet("http://" + subscribeUrl + "/" + topic).execute();
        Response response = (Response)execute.get(10L, TimeUnit.SECONDS);
        if (response.getStatusCode() == HttpConstants.ResponseStatusCodes.OK_200) {
            String responseBody = response.getResponseBody();
            LOG.info(responseBody);
            return responseBody;
        }
        throw new IllegalStateException("HTTP response code error: " + response.getStatusCode());
    }

    public void registerMessageListener(EventMeshMessageListenerConcurrently messageListener) {
        this.messageListener = messageListener;
    }
}

