/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.knative.cloudevent;

import io.cloudevents.CloudEvent;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.eventmesh.connector.knative.cloudevent.impl.KnativeMessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KnativeMessageFactory {
    private static final Logger log = LoggerFactory.getLogger(KnativeMessageFactory.class);

    private KnativeMessageFactory() {
    }

    public static String createReader(CloudEvent message) {
        if (message.getData() == null) {
            log.warn("CloudEvent message's data is null.");
            return "";
        }
        return new String(message.getData().toBytes(), StandardCharsets.UTF_8);
    }

    public static KnativeMessageWriter createWriter(Properties properties) {
        return new KnativeMessageWriter(properties);
    }
}

