/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pulsar.client;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.provider.EventFormatProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.connector.pulsar.config.ClientConfiguration;
import org.apache.eventmesh.connector.pulsar.utils.CloudEventUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarClientWrapper {
    private static final Logger log = LoggerFactory.getLogger(PulsarClientWrapper.class);
    private ClientConfiguration config;
    private PulsarClient pulsarClient;
    private Map<String, Producer<byte[]>> producerMap = new HashMap<String, Producer<byte[]>>();

    public PulsarClientWrapper(ClientConfiguration config) {
        this.config = config;
        try {
            ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(config.getServiceAddr());
            if (config.getAuthPlugin() != null) {
                Preconditions.checkNotNull((Object)config.getAuthParams(), (Object)"Authentication Enabled in pulsar cluster, Please set authParams in pulsar-client.properties");
                clientBuilder.authentication(config.getAuthPlugin(), config.getAuthParams());
            }
            this.pulsarClient = clientBuilder.build();
        }
        catch (PulsarClientException ex) {
            throw new ConnectorRuntimeException(String.format("Failed to connect pulsar cluster %s with exception: %s", config.getServiceAddr(), ex.getMessage()));
        }
    }

    private Producer<byte[]> createProducer(String topic) {
        try {
            return this.pulsarClient.newProducer().topic(topic).batchingMaxPublishDelay(10L, TimeUnit.MILLISECONDS).sendTimeout(10, TimeUnit.SECONDS).blockIfQueueFull(true).create();
        }
        catch (PulsarClientException ex) {
            throw new ConnectorRuntimeException(String.format("Failed to create pulsar producer for %s with exception: %s", topic, ex.getMessage()));
        }
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) {
        String topic = cloudEvent.getSubject();
        Producer producer = this.producerMap.computeIfAbsent(topic, k -> this.createProducer(topic));
        try {
            byte[] serializedCloudEvent = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json").serialize(cloudEvent);
            producer.sendAsync((Object)serializedCloudEvent).thenAccept(messageId -> sendCallback.onSuccess(CloudEventUtils.convertSendResult(cloudEvent)));
        }
        catch (Exception ex) {
            log.error("Failed to publish cloudEvent for {} with exception: {}", (Object)cloudEvent.getSubject(), (Object)ex.getMessage());
        }
    }

    public void shutdown() throws PulsarClientException {
        this.pulsarClient.close();
        for (Map.Entry<String, Producer<byte[]>> producerEntry : this.producerMap.entrySet()) {
            producerEntry.getValue().close();
        }
        this.producerMap.clear();
    }
}

