/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry.RetryContext;
import org.apache.eventmesh.runtime.util.EventMeshThreadFactoryImpl;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcpRetryer {
    public static final Logger logger = LoggerFactory.getLogger(EventMeshTcpRetryer.class);
    private EventMeshTCPServer eventMeshTCPServer;
    private DelayQueue<RetryContext> retrys = new DelayQueue();
    private ThreadPoolExecutor pool = new ThreadPoolExecutor(3, 3, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1000), new EventMeshThreadFactoryImpl("eventMesh-tcp-retry", true), new ThreadPoolExecutor.AbortPolicy());
    private Thread dispatcher;

    public EventMeshTcpRetryer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public void setEventMeshTCPServer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public void pushRetry(RetryContext retryContext) {
        if (this.retrys.size() >= this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpMsgRetryQueueSize) {
            logger.error("pushRetry fail,retrys is too much,allow max retryQueueSize:{}, retryTimes:{}, seq:{}, bizSeq:{}", new Object[]{this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpMsgRetryQueueSize, retryContext.retryTimes, retryContext.seq, EventMeshUtil.getMessageBizSeq(retryContext.event)});
            return;
        }
        int maxRetryTimes = this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpMsgAsyncRetryTimes;
        if (retryContext instanceof DownStreamMsgContext) {
            DownStreamMsgContext downStreamMsgContext = (DownStreamMsgContext)retryContext;
            int n = maxRetryTimes = SubscriptionType.SYNC == downStreamMsgContext.subscriptionItem.getType() ? this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpMsgSyncRetryTimes : this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpMsgAsyncRetryTimes;
        }
        if (retryContext.retryTimes >= maxRetryTimes) {
            logger.warn("pushRetry fail,retry over maxRetryTimes:{}, retryTimes:{}, seq:{}, bizSeq:{}", new Object[]{maxRetryTimes, retryContext.retryTimes, retryContext.seq, EventMeshUtil.getMessageBizSeq(retryContext.event)});
            return;
        }
        this.retrys.offer(retryContext);
        logger.info("pushRetry success,seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{retryContext.seq, retryContext.retryTimes, EventMeshUtil.getMessageBizSeq(retryContext.event)});
    }

    public void init() {
        this.dispatcher = new Thread(() -> {
            try {
                RetryContext retryContext;
                while ((retryContext = (RetryContext)this.retrys.take()) != null) {
                    this.pool.execute(retryContext::retry);
                }
            }
            catch (Exception e) {
                logger.error("retry-dispatcher error!", (Throwable)e);
            }
        }, "retry-dispatcher");
        this.dispatcher.setDaemon(true);
        logger.info("EventMeshTcpRetryer inited......");
    }

    public void start() throws Exception {
        this.dispatcher.start();
        logger.info("EventMeshTcpRetryer started......");
    }

    public void shutdown() {
        this.pool.shutdown();
        logger.info("EventMeshTcpRetryer shutdown......");
    }

    public int getRetrySize() {
        return this.retrys.size();
    }

    public void printRetryThreadPoolState() {
    }
}

