/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcpExceptionHandler
extends ChannelDuplexHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private EventMeshTCPServer eventMeshTCPServer;

    public EventMeshTcpExceptionHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
        UserAgent client = session == null ? null : session.getClient();
        this.logger.error("exceptionCaught, push goodbye to client|user={},errMsg={}", (Object)client, (Object)cause.fillInStackTrace());
        String errMsg = cause.toString().contains("value not one of declared Enum instance names") ? "Unknown Command type" : cause.toString();
        if (session != null) {
            EventMeshTcp2Client.goodBye2Client(this.eventMeshTCPServer, session, errMsg, OPStatus.FAIL.getCode(), this.eventMeshTCPServer.getClientSessionGroupMapping());
        } else {
            EventMeshTcp2Client.goodBye2Client(ctx, errMsg, this.eventMeshTCPServer.getClientSessionGroupMapping(), this.eventMeshTCPServer.getEventMeshTcpMonitor());
        }
    }
}

