/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor.inf;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.utils.AssertUtils;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupMetadata;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicMetadata;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AsyncHttpProcessor;
import org.apache.eventmesh.runtime.registry.Registry;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventProcessor
implements AsyncHttpProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractEventProcessor.class);
    protected transient EventMeshHTTPServer eventMeshHTTPServer;

    public AbstractEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    protected void updateMetadata() {
        if (!this.eventMeshHTTPServer.getEventMeshHttpConfiguration().isEventMeshServerRegistryEnable()) {
            return;
        }
        try {
            HashMap<String, String> metadata = new HashMap<String, String>(16);
            for (Map.Entry<String, ConsumerGroupConf> consumerGroupMap : this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().entrySet()) {
                String consumerGroupKey = consumerGroupMap.getKey();
                ConsumerGroupConf consumerGroupConf = consumerGroupMap.getValue();
                ConsumerGroupMetadata consumerGroupMetadata = new ConsumerGroupMetadata();
                consumerGroupMetadata.setConsumerGroup(consumerGroupKey);
                HashMap<String, ConsumerGroupTopicMetadata> consumerGroupTopicMetadataMap = new HashMap<String, ConsumerGroupTopicMetadata>(16);
                for (Map.Entry<String, ConsumerGroupTopicConf> consumerGroupTopicConfEntry : consumerGroupConf.getConsumerGroupTopicConf().entrySet()) {
                    String topic = consumerGroupTopicConfEntry.getKey();
                    ConsumerGroupTopicConf consumerGroupTopicConf = consumerGroupTopicConfEntry.getValue();
                    ConsumerGroupTopicMetadata consumerGroupTopicMetadata = new ConsumerGroupTopicMetadata();
                    consumerGroupTopicMetadata.setConsumerGroup(consumerGroupTopicConf.getConsumerGroup());
                    consumerGroupTopicMetadata.setTopic(consumerGroupTopicConf.getTopic());
                    consumerGroupTopicMetadata.setUrls(consumerGroupTopicConf.getUrls());
                    consumerGroupTopicMetadataMap.put(topic, consumerGroupTopicMetadata);
                }
                consumerGroupMetadata.setConsumerGroupTopicMetadataMap(consumerGroupTopicMetadataMap);
                metadata.put(consumerGroupKey, JsonUtils.serialize((Object)consumerGroupMetadata));
            }
            this.eventMeshHTTPServer.getRegistry().registerMetadata(metadata);
        }
        catch (Exception e) {
            log.error("[LocalSubscribeEventProcessor] update eventmesh metadata error", (Throwable)e);
        }
    }

    protected String getTargetMesh(String consumerGroup, List<SubscriptionItem> subscriptionList) throws Exception {
        EventMeshHTTPConfiguration httpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        if (!httpConfiguration.isEventMeshServerRegistryEnable()) {
            return "";
        }
        String targetMesh = "";
        Registry registry = this.eventMeshHTTPServer.getRegistry();
        List<EventMeshDataInfo> allEventMeshInfo = registry.findAllEventMeshInfo();
        String httpServiceName = "HTTP-GROUP@@" + httpConfiguration.getEventMeshName() + "-" + "HTTP";
        block0: for (EventMeshDataInfo eventMeshDataInfo : allEventMeshInfo) {
            Map metadata;
            String topicMetadataJson;
            if (!eventMeshDataInfo.getEventMeshName().equals(httpServiceName) || httpConfiguration.getEventMeshCluster().equals(eventMeshDataInfo.getEventMeshClusterName()) || StringUtils.isBlank((CharSequence)(topicMetadataJson = (String)(metadata = eventMeshDataInfo.getMetadata()).get(consumerGroup)))) continue;
            ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)JsonUtils.deserialize((String)topicMetadataJson, ConsumerGroupMetadata.class);
            Map consumerGroupTopicMetadataMap = Optional.ofNullable(consumerGroupMetadata).map(ConsumerGroupMetadata::getConsumerGroupTopicMetadataMap).orElseGet(Maps::newConcurrentMap);
            for (SubscriptionItem subscriptionItem : subscriptionList) {
                if (!consumerGroupTopicMetadataMap.containsKey(subscriptionItem.getTopic())) continue;
                targetMesh = "http://" + eventMeshDataInfo.getEndpoint() + "/eventmesh/subscribe/local";
                break block0;
            }
        }
        return targetMesh;
    }

    protected Map<String, Object> builderResponseHeaderMap(HttpEventWrapper requestWrapper) {
        HashMap<String, Object> responseHeaderMap = new HashMap<String, Object>();
        EventMeshHTTPConfiguration eventMeshHttpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", eventMeshHttpConfiguration.getEventMeshCluster());
        responseHeaderMap.put("eventmeship", IPUtils.getLocalAddress());
        responseHeaderMap.put("eventmeshenv", eventMeshHttpConfiguration.getEventMeshEnv());
        responseHeaderMap.put("eventmeshidc", eventMeshHttpConfiguration.getEventMeshIDC());
        return responseHeaderMap;
    }

    protected boolean validateSysHeader(Map<String, Object> sysHeaderMap) {
        return StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sysHeaderMap.get("idc").toString(), sysHeaderMap.get("pid").toString(), sysHeaderMap.get("sys").toString()}) || !StringUtils.isNumeric((CharSequence)sysHeaderMap.get("pid").toString());
    }

    protected boolean validatedRequestBodyMap(Map<String, Object> requestBodyMap) {
        return requestBodyMap.get("url") == null || requestBodyMap.get("topic") == null || requestBodyMap.get("consumerGroup") == null;
    }

    protected Map<String, String> builderRemoteHeaderMap(String localAddress) {
        EventMeshHTTPConfiguration eventMeshHttpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        String meshGroup = eventMeshHttpConfiguration.getMeshGroup();
        HashMap<String, String> remoteHeaderMap = new HashMap<String, String>();
        remoteHeaderMap.put("env", eventMeshHttpConfiguration.getEventMeshEnv());
        remoteHeaderMap.put("idc", eventMeshHttpConfiguration.getEventMeshIDC());
        remoteHeaderMap.put("ip", localAddress);
        remoteHeaderMap.put("pid", String.valueOf(ThreadUtils.getPID()));
        remoteHeaderMap.put("sys", eventMeshHttpConfiguration.getSysID());
        remoteHeaderMap.put("username", "eventmesh");
        remoteHeaderMap.put("passwd", "pass");
        remoteHeaderMap.put("producergroup", meshGroup);
        remoteHeaderMap.put("consumergroup", meshGroup);
        return remoteHeaderMap;
    }

    public static String post(CloseableHttpClient client, String uri, Map<String, String> requestHeader, Map<String, Object> requestBody, ResponseHandler<String> responseHandler) throws IOException {
        AssertUtils.notNull((Object)client, (String)"client can't be null");
        AssertUtils.notBlack((String)uri, (String)"uri can't be null");
        AssertUtils.notNull(requestHeader, (String)"requestParam can't be null");
        AssertUtils.notNull(responseHandler, (String)"responseHandler can't be null");
        HttpPost httpPost = new HttpPost(uri);
        httpPost.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        if (MapUtils.isNotEmpty(requestHeader)) {
            requestHeader.forEach((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
        }
        if (MapUtils.isNotEmpty(requestBody)) {
            String jsonStr = Optional.ofNullable(JsonUtils.serialize(requestBody)).orElse("");
            httpPost.setEntity((HttpEntity)new StringEntity(jsonStr, ContentType.APPLICATION_JSON));
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setSocketTimeout(Integer.parseInt(String.valueOf(15000))).setConnectTimeout(Integer.parseInt(String.valueOf(15000))).setConnectionRequestTimeout(Integer.parseInt(String.valueOf(15000)));
        httpPost.setConfig(configBuilder.build());
        return (String)client.execute((HttpUriRequest)httpPost, responseHandler);
    }
}

