/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendSyncMessageProcessor
implements HttpRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(SendSyncMessageProcessor.class);
    private transient EventMeshHTTPServer eventMeshHTTPServer;

    public SendSyncMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(final ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        block18: {
            CloudEvent newEevent;
            String localAddress = IPUtils.getLocalAddress();
            if (log.isInfoEnabled()) {
                log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
            }
            ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)"cloudevents");
            CloudEvent event = httpCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)asyncContext.getRequest());
            final SendMessageResponseHeader sendMessageResponseHeader = SendMessageResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster(), (String)localAddress, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
            if (event == null || StringUtils.isBlank((CharSequence)event.getId()) || event.getSource() == null || event.getSpecVersion() == null || StringUtils.isBlank((CharSequence)event.getType()) || StringUtils.isBlank((CharSequence)event.getSubject())) {
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            String idc = Objects.requireNonNull(event.getExtension("idc")).toString();
            String pid = Objects.requireNonNull(event.getExtension("pid")).toString();
            String sys = Objects.requireNonNull(event.getExtension("sys")).toString();
            if (StringUtils.isBlank((CharSequence)idc) || StringUtils.isBlank((CharSequence)pid) || !StringUtils.isNumeric((CharSequence)pid) || StringUtils.isBlank((CharSequence)sys)) {
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            final String bizNo = Objects.requireNonNull(event.getExtension("bizseqno")).toString();
            final String uniqueId = Objects.requireNonNull(event.getExtension("uniqueid")).toString();
            String producerGroup = Objects.requireNonNull(event.getExtension("producergroup")).toString();
            final String topic = event.getSubject();
            String ttl = Objects.requireNonNull(event.getExtension("ttl")).toString();
            if (StringUtils.isBlank((CharSequence)bizNo) || StringUtils.isBlank((CharSequence)uniqueId) || StringUtils.isBlank((CharSequence)producerGroup) || StringUtils.isBlank((CharSequence)topic) || event.getData() == null || StringUtils.isBlank((CharSequence)ttl)) {
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().isEventMeshServerSecurityEnable()) {
                String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                String user = Objects.requireNonNull(event.getExtension("username")).toString();
                String pass = Objects.requireNonNull(event.getExtension("passwd")).toString();
                int requestCode = Integer.parseInt(asyncContext.getRequest().getRequestCode());
                try {
                    Acl.doAclCheckInHttpSend(remoteAddr, user, pass, sys, topic, requestCode);
                }
                catch (Exception e) {
                    HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_ACL_ERR.getRetCode(), (String)e.getMessage()));
                    asyncContext.onComplete(responseEventMeshCommand);
                    if (log.isWarnEnabled()) {
                        log.warn("CLIENT HAS NO PERMISSION,SendSyncMessageProcessor send failed", (Throwable)e);
                    }
                    return;
                }
            }
            if (!this.eventMeshHTTPServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR.getErrMsg()));
                this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPDiscard();
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            String content = new String(Objects.requireNonNull(event.getData()).toBytes(), StandardCharsets.UTF_8);
            if (content.length() > this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize) {
                if (log.isErrorEnabled()) {
                    log.error("Event size exceeds the limit: {}", (Object)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize);
                }
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)("Event size exceeds the limit: " + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize)));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
            if (!eventMeshProducer.getStarted().get()) {
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getErrMsg()));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            try {
                newEevent = CloudEventBuilder.from((CloudEvent)event).withExtension("msgtype", "persistent").withExtension("reqc2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
                if (log.isDebugEnabled()) {
                    log.debug("msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)bizNo, (Object)topic);
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("msg2MQMsg err, bizSeqNo={}, topic={}", new Object[]{bizNo, topic, e});
                }
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            final SendMessageContext sendMessageContext = new SendMessageContext(bizNo, newEevent, eventMeshProducer, this.eventMeshHTTPServer);
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsg();
            final long startTime = System.currentTimeMillis();
            final CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

                @Override
                public void onResponse(HttpCommand httpCommand) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("{}", (Object)httpCommand);
                        }
                        SendSyncMessageProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                        SendSyncMessageProcessor.this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                    }
                    catch (Exception ex) {
                        log.error("onResponse error", (Throwable)ex);
                    }
                }
            };
            try {
                eventMeshProducer.request(sendMessageContext, new RequestReplyCallback(){

                    public void onSuccess(CloudEvent event) {
                        block3: {
                            if (log.isInfoEnabled()) {
                                log.info("message|mq2eventMesh|RSP|SYNC|rrCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId});
                            }
                            try {
                                CloudEvent newEvent = CloudEventBuilder.from((CloudEvent)event).withExtension("rspeventmesh2ctimestamp", String.valueOf(System.currentTimeMillis())).withExtension("rspmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).build();
                                String rtnMsg = new String(Objects.requireNonNull(newEvent.getData()).toBytes(), StandardCharsets.UTF_8);
                                HttpCommand succ = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)JsonUtils.serialize((Object)SendMessageResponseBody.ReplyMessage.builder().topic(topic).body(rtnMsg).properties(EventMeshUtil.getEventProp(newEvent)).build())));
                                asyncContext.onComplete(succ, handler);
                            }
                            catch (Exception ex) {
                                HttpCommand err = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2))));
                                asyncContext.onComplete(err, handler);
                                if (!log.isWarnEnabled()) break block3;
                                log.warn("message|mq2eventMesh|RSP", (Throwable)ex);
                            }
                        }
                    }

                    public void onException(Throwable e) {
                        HttpCommand err = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                        asyncContext.onComplete(err, handler);
                        SendSyncMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                        if (log.isErrorEnabled()) {
                            log.error("message|mq2eventMesh|RSP|SYNC|rrCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId, e});
                        }
                    }
                }, Integer.parseInt(ttl));
            }
            catch (Exception ex) {
                HttpCommand err = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SEND_SYNC_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SEND_SYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2))));
                asyncContext.onComplete(err);
                this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                long endTime = System.currentTimeMillis();
                this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgFailed();
                this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                if (!log.isErrorEnabled()) break block18;
                log.error("message|eventMesh2mq|REQ|SYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId, ex});
            }
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

