/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.header.client.SubscribeRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.UnSubscribeRequestHeader;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupMetadata;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicMetadata;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientGroupMapping {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientGroupMapping.class);
    private final transient Map<String, ConsumerGroupConf> localConsumerGroupMapping = new ConcurrentHashMap<String, ConsumerGroupConf>();
    private final transient Map<String, List<Client>> localClientInfoMapping = new ConcurrentHashMap<String, List<Client>>();
    private final transient Set<String> localTopicSet = new HashSet<String>(16);
    private static final transient ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();

    private HttpClientGroupMapping() {
    }

    public static HttpClientGroupMapping getInstance() {
        return Singleton.INSTANCE;
    }

    public Set<String> getLocalTopicSet() {
        return this.localTopicSet;
    }

    public Map<String, List<Client>> getLocalClientInfoMapping() {
        return this.localClientInfoMapping;
    }

    public ConsumerGroupConf getConsumerGroupConfByGroup(String consumerGroup) {
        return this.localConsumerGroupMapping.get(consumerGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubscription(String consumerGroup, String url, String clientIdc, List<SubscriptionItem> subscriptionList) {
        Objects.requireNonNull(url, "url can not be null");
        Objects.requireNonNull(consumerGroup, "consumerGroup can not be null");
        Objects.requireNonNull(clientIdc, "clientIdc can not be null");
        Objects.requireNonNull(subscriptionList, "subscriptionList can not be null");
        boolean isChange = false;
        try {
            READ_WRITE_LOCK.writeLock().lock();
            for (SubscriptionItem subTopic : subscriptionList) {
                isChange = isChange || this.addSubscriptionByTopic(consumerGroup, url, clientIdc, subTopic);
            }
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
        return isChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSubscription(String consumerGroup, String unSubscribeUrl, String clientIdc, List<String> unSubTopicList) {
        Objects.requireNonNull(unSubTopicList, "unSubTopicList can not be null");
        boolean isChange = false;
        try {
            READ_WRITE_LOCK.writeLock().lock();
            for (String unSubTopic : unSubTopicList) {
                isChange = isChange || this.removeSubscriptionByTopic(consumerGroup, unSubscribeUrl, clientIdc, unSubTopic);
            }
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
        return isChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConsumerGroupTopicConf> querySubscription() {
        try {
            READ_WRITE_LOCK.readLock().lock();
            if (MapUtils.isEmpty(this.localConsumerGroupMapping)) {
                ArrayList<ConsumerGroupTopicConf> arrayList = new ArrayList<ConsumerGroupTopicConf>();
                return arrayList;
            }
            ArrayList<ConsumerGroupTopicConf> consumerGroupTopicConfList = new ArrayList<ConsumerGroupTopicConf>();
            for (ConsumerGroupConf consumerGroupConf : this.localConsumerGroupMapping.values()) {
                if (MapUtils.isEmpty(consumerGroupConf.getConsumerGroupTopicConf())) continue;
                for (ConsumerGroupTopicConf consumerGroupTopicConf : consumerGroupConf.getConsumerGroupTopicConf().values()) {
                    consumerGroupTopicConfList.add(consumerGroupTopicConf);
                }
            }
            ArrayList<ConsumerGroupTopicConf> arrayList = consumerGroupTopicConfList;
            return arrayList;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> prepareMetaData() {
        HashMap<String, String> metadata = new HashMap<String, String>(16);
        try {
            READ_WRITE_LOCK.readLock().lock();
            for (Map.Entry<String, ConsumerGroupConf> consumerGroupMap : this.localConsumerGroupMapping.entrySet()) {
                String consumerGroupKey = consumerGroupMap.getKey();
                ConsumerGroupConf consumerGroupConf = consumerGroupMap.getValue();
                ConsumerGroupMetadata consumerGroupMetadata = new ConsumerGroupMetadata();
                consumerGroupMetadata.setConsumerGroup(consumerGroupKey);
                HashMap<String, ConsumerGroupTopicMetadata> consumerGroupTopicMetadataMap = new HashMap<String, ConsumerGroupTopicMetadata>(16);
                for (Map.Entry<String, ConsumerGroupTopicConf> consumerGroupTopicConfEntry : consumerGroupConf.getConsumerGroupTopicConf().entrySet()) {
                    ConsumerGroupTopicConf consumerGroupTopicConf = consumerGroupTopicConfEntry.getValue();
                    ConsumerGroupTopicMetadata consumerGroupTopicMetadata = new ConsumerGroupTopicMetadata();
                    consumerGroupTopicMetadata.setConsumerGroup(consumerGroupTopicConf.getConsumerGroup());
                    consumerGroupTopicMetadata.setTopic(consumerGroupTopicConf.getTopic());
                    consumerGroupTopicMetadata.setUrls(consumerGroupTopicConf.getUrls());
                    consumerGroupTopicMetadataMap.put(consumerGroupTopicConfEntry.getKey(), consumerGroupTopicMetadata);
                }
                consumerGroupMetadata.setConsumerGroupTopicMetadataMap(consumerGroupTopicMetadataMap);
                metadata.put(consumerGroupKey, JsonUtils.serialize((Object)consumerGroupMetadata));
            }
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
        metadata.put("topicSet", JsonUtils.serialize(this.localTopicSet));
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubscriptionForRequestCode(SubscribeRequestHeader subscribeRequestHeader, String consumerGroup, String url, List<SubscriptionItem> subscriptionList) {
        Objects.requireNonNull(url, "url can not be null");
        Objects.requireNonNull(consumerGroup, "consumerGroup can not be null");
        Objects.requireNonNull(subscribeRequestHeader, "subscribeRequestHeader can not be null");
        Objects.requireNonNull(subscriptionList, "subscriptionList can not be null");
        boolean isChange = false;
        try {
            READ_WRITE_LOCK.writeLock().lock();
            this.registerClientForSub(subscribeRequestHeader, consumerGroup, subscriptionList, url);
            for (SubscriptionItem subTopic : subscriptionList) {
                isChange = isChange || this.addSubscriptionByTopic(consumerGroup, url, subscribeRequestHeader.getIdc(), subTopic);
            }
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
        return isChange;
    }

    private boolean addSubscriptionByTopic(String consumerGroup, String url, String clientIdc, SubscriptionItem subTopic) {
        Objects.requireNonNull(url, "url can not be null");
        Objects.requireNonNull(consumerGroup, "consumerGroup can not be null");
        Objects.requireNonNull(clientIdc, "clientIdc can not be null");
        Objects.requireNonNull(subTopic, "subTopic can not be null");
        boolean isChange = false;
        ConsumerGroupConf consumerGroupConf = this.localConsumerGroupMapping.get(consumerGroup);
        if (consumerGroupConf == null) {
            consumerGroupConf = new ConsumerGroupConf(consumerGroup);
            ConsumerGroupTopicConf consumeTopicConfig = new ConsumerGroupTopicConf();
            consumeTopicConfig.setConsumerGroup(consumerGroup);
            consumeTopicConfig.setTopic(subTopic.getTopic());
            consumeTopicConfig.setSubscriptionItem(subTopic);
            consumeTopicConfig.setUrls(new HashSet<String>(Collections.singletonList(url)));
            HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
            ArrayList<String> urls = new ArrayList<String>();
            urls.add(url);
            idcUrls.put(clientIdc, urls);
            consumeTopicConfig.setIdcUrls(idcUrls);
            consumerGroupConf.getConsumerGroupTopicConf().put(subTopic.getTopic(), consumeTopicConfig);
            this.localConsumerGroupMapping.put(consumerGroup, consumerGroupConf);
            isChange = true;
        } else {
            Map<String, ConsumerGroupTopicConf> map = consumerGroupConf.getConsumerGroupTopicConf();
            if (!map.containsKey(subTopic.getTopic())) {
                ConsumerGroupTopicConf newTopicConf = new ConsumerGroupTopicConf();
                newTopicConf.setConsumerGroup(consumerGroup);
                newTopicConf.setTopic(subTopic.getTopic());
                newTopicConf.setSubscriptionItem(subTopic);
                newTopicConf.setUrls(new HashSet<String>(Collections.singletonList(url)));
                HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
                ArrayList<String> urls = new ArrayList<String>();
                urls.add(url);
                idcUrls.put(clientIdc, urls);
                newTopicConf.setIdcUrls(idcUrls);
                map.put(subTopic.getTopic(), newTopicConf);
                isChange = true;
            } else {
                ConsumerGroupTopicConf currentTopicConf = map.get(subTopic.getTopic());
                if (!currentTopicConf.getUrls().add(url)) {
                    isChange = true;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("add subscribe success, group:{}, url:{} , topic:{}", new Object[]{consumerGroup, url, subTopic.getTopic()});
                    }
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("The group has subscribed, group:{}, url:{} , topic:{}", new Object[]{consumerGroup, url, subTopic.getTopic()});
                }
                if (!currentTopicConf.getIdcUrls().containsKey(clientIdc)) {
                    ArrayList<String> urls = new ArrayList<String>();
                    urls.add(url);
                    currentTopicConf.getIdcUrls().put(clientIdc, urls);
                    isChange = true;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("add url to idcUrlMap success, group:{}, url:{}, topic:{}, clientIdc:{}", new Object[]{consumerGroup, url, subTopic.getTopic(), clientIdc});
                    }
                } else {
                    HashSet tmpSet = new HashSet(currentTopicConf.getIdcUrls().get(clientIdc));
                    if (!tmpSet.contains(url)) {
                        currentTopicConf.getIdcUrls().get(clientIdc).add(url);
                        isChange = true;
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("add url to idcUrlMap success, group:{}, url:{}, topic:{}, clientIdc:{}", new Object[]{consumerGroup, url, subTopic.getTopic(), clientIdc});
                        }
                    } else if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("The idcUrlMap has contains url, group:{}, url:{} , topic:{}, clientIdc:{}", new Object[]{consumerGroup, url, subTopic.getTopic(), clientIdc});
                    }
                }
            }
        }
        return isChange;
    }

    private boolean removeSubscriptionByTopic(String consumerGroup, String unSubscribeUrl, String clientIdc, String unSubTopic) {
        Objects.requireNonNull(unSubscribeUrl, "unSubscribeUrl can not be null");
        Objects.requireNonNull(consumerGroup, "consumerGroup can not be null");
        Objects.requireNonNull(clientIdc, "clientIdc can not be null");
        Objects.requireNonNull(unSubTopic, "unSubTopic can not be null");
        boolean isChange = false;
        ConsumerGroupConf consumerGroupConf = this.localConsumerGroupMapping.get(consumerGroup);
        if (consumerGroupConf == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("unsubscribe fail, the current mesh does not have group subscriptionInfo, group:{}, url:{}", (Object)consumerGroup, (Object)unSubscribeUrl);
            }
            return false;
        }
        ConsumerGroupTopicConf consumerGroupTopicConf = consumerGroupConf.getConsumerGroupTopicConf().get(unSubTopic);
        if (consumerGroupTopicConf == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("unsubscribe fail, the current mesh does not have group-topic subscriptionInfo, group:{}, topic:{}, url:{}", new Object[]{consumerGroup, unSubTopic, unSubscribeUrl});
            }
            return false;
        }
        if (consumerGroupTopicConf.getUrls().remove(unSubscribeUrl)) {
            isChange = true;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("remove url success, group:{}, topic:{}, url:{}", new Object[]{consumerGroup, unSubTopic, unSubscribeUrl});
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("remove url fail, not exist subscrition of this url, group:{}, topic:{}, url:{}", new Object[]{consumerGroup, unSubTopic, unSubscribeUrl});
        }
        if (consumerGroupTopicConf.getIdcUrls().containsKey(clientIdc)) {
            if (consumerGroupTopicConf.getIdcUrls().get(clientIdc).remove(unSubscribeUrl)) {
                isChange = true;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("remove url from idcUrlMap success, group:{}, topic:{}, url:{}, clientIdc:{}", new Object[]{consumerGroup, unSubTopic, unSubscribeUrl, clientIdc});
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("remove url from idcUrlMap fail,not exist subscrition of this url, group:{}, topic:{}, url:{}, clientIdc:{}", new Object[]{consumerGroup, unSubTopic, unSubscribeUrl, clientIdc});
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("remove url from idcUrlMap fail,not exist subscrition of this idc , group:{}, topic:{}, url:{}, clientIdc:{}", new Object[]{consumerGroup, unSubTopic, unSubscribeUrl, clientIdc});
        }
        if (isChange && consumerGroupTopicConf.getUrls().size() == 0) {
            consumerGroupConf.getConsumerGroupTopicConf().remove(unSubTopic);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("group unsubscribe topic success,group:{}, topic:{}", (Object)consumerGroup, (Object)unSubTopic);
            }
        }
        if (isChange && consumerGroupConf.getConsumerGroupTopicConf().size() == 0) {
            this.localConsumerGroupMapping.remove(consumerGroup);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("group unsubscribe success,group:{}", (Object)consumerGroup);
            }
        }
        return isChange;
    }

    private void registerClientForSub(SubscribeRequestHeader subscribeRequestHeader, String consumerGroup, List<SubscriptionItem> subscriptionItems, String url) {
        Objects.requireNonNull(subscribeRequestHeader, "subscribeRequestHeader can not be null");
        Objects.requireNonNull(consumerGroup, "consumerGroup can not be null");
        Objects.requireNonNull(subscriptionItems, "subscriptionItems can not be null");
        Objects.requireNonNull(url, "url can not be null");
        for (SubscriptionItem item : subscriptionItems) {
            Client client = new Client();
            client.setEnv(subscribeRequestHeader.getEnv());
            client.setIdc(subscribeRequestHeader.getIdc());
            client.setSys(subscribeRequestHeader.getSys());
            client.setIp(subscribeRequestHeader.getIp());
            client.setPid(subscribeRequestHeader.getPid());
            client.setConsumerGroup(consumerGroup);
            client.setTopic(item.getTopic());
            client.setUrl(url);
            client.setLastUpTime(new Date());
            String groupTopicKey = client.getConsumerGroup() + "@" + client.getTopic();
            if (this.localClientInfoMapping.containsKey(groupTopicKey)) {
                List<Client> localClients = this.localClientInfoMapping.get(groupTopicKey);
                boolean isContains = false;
                for (Client localClient : localClients) {
                    if (!StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)client.getUrl())) continue;
                    isContains = true;
                    localClient.setLastUpTime(client.getLastUpTime());
                    break;
                }
                if (isContains) continue;
                localClients.add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            this.localClientInfoMapping.put(groupTopicKey, clients);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSubscriptionForRequestCode(UnSubscribeRequestHeader unSubscribeRequestHeader, String consumerGroup, String unSubscribeUrl, List<String> unSubTopicList) {
        Objects.requireNonNull(unSubTopicList, "unSubTopicList can not be null");
        Objects.requireNonNull(unSubscribeRequestHeader, "unSubscribeRequestHeader can not be null");
        Objects.requireNonNull(consumerGroup, "consumerGroup can not be null");
        Objects.requireNonNull(unSubscribeUrl, "unSubscribeUrl can not be null");
        boolean isChange = false;
        try {
            READ_WRITE_LOCK.writeLock().lock();
            this.registerClientForUnsub(unSubscribeRequestHeader, consumerGroup, unSubTopicList, unSubscribeUrl);
            for (String unSubTopic : unSubTopicList) {
                isChange = isChange || this.removeSubscriptionByTopic(consumerGroup, unSubscribeUrl, unSubscribeRequestHeader.getIdc(), unSubTopic);
            }
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
        return isChange;
    }

    private void registerClientForUnsub(UnSubscribeRequestHeader unSubscribeRequestHeader, String consumerGroup, List<String> topicList, String url) {
        Objects.requireNonNull(topicList, "topicList can not be null");
        Objects.requireNonNull(unSubscribeRequestHeader, "unSubscribeRequestHeader can not be null");
        Objects.requireNonNull(consumerGroup, "consumerGroup can not be null");
        Objects.requireNonNull(url, "url can not be null");
        for (String topic : topicList) {
            Client client = new Client();
            client.setEnv(unSubscribeRequestHeader.getEnv());
            client.setIdc(unSubscribeRequestHeader.getIdc());
            client.setSys(unSubscribeRequestHeader.getSys());
            client.setIp(unSubscribeRequestHeader.getIp());
            client.setPid(unSubscribeRequestHeader.getPid());
            client.setConsumerGroup(consumerGroup);
            client.setTopic(topic);
            client.setUrl(url);
            client.setLastUpTime(new Date());
            String groupTopicKey = client.getConsumerGroup() + "@" + client.getTopic();
            if (this.localClientInfoMapping.containsKey(groupTopicKey)) {
                List<Client> localClients = this.localClientInfoMapping.get(groupTopicKey);
                boolean isContains = false;
                for (Client localClient : localClients) {
                    if (!StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)client.getUrl())) continue;
                    isContains = true;
                    localClient.setLastUpTime(client.getLastUpTime());
                    break;
                }
                if (isContains) continue;
                localClients.add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            this.localClientInfoMapping.put(groupTopicKey, clients);
        }
    }

    private static class Singleton {
        private static final HttpClientGroupMapping INSTANCE = new HttpClientGroupMapping();

        private Singleton() {
        }
    }
}

