/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.consumer;

import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.event.ConsumerGroupStateEvent;
import org.apache.eventmesh.runtime.core.consumergroup.event.ConsumerGroupTopicConfChangeEvent;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.ConsumerGroupManager;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerManager {
    private EventMeshHTTPServer eventMeshHTTPServer;
    private ConcurrentHashMap<String, ConsumerGroupManager> consumerTable = new ConcurrentHashMap();
    private static final int DEFAULT_UPDATE_TIME = 90000;
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public ConsumerManager(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    public void init() throws Exception {
        this.eventMeshHTTPServer.getEventBus().register((Object)this);
        this.logger.info("consumerManager inited......");
    }

    public void start() throws Exception {
        this.logger.info("consumerManager started......");
    }

    public void notifyConsumerManager(String consumerGroup, ConsumerGroupConf latestConsumerGroupConfig) throws Exception {
        ConsumerGroupManager cgm = this.eventMeshHTTPServer.getConsumerManager().getConsumer(consumerGroup);
        if (latestConsumerGroupConfig == null) {
            ConsumerGroupStateEvent notification = new ConsumerGroupStateEvent();
            notification.action = ConsumerGroupStateEvent.ConsumerGroupStateAction.DELETE;
            notification.consumerGroup = consumerGroup;
            this.eventMeshHTTPServer.getEventBus().post((Object)notification);
            return;
        }
        if (cgm == null) {
            ConsumerGroupStateEvent notification = new ConsumerGroupStateEvent();
            notification.action = ConsumerGroupStateEvent.ConsumerGroupStateAction.NEW;
            notification.consumerGroup = consumerGroup;
            notification.consumerGroupConfig = EventMeshUtil.cloneObject(latestConsumerGroupConfig);
            this.eventMeshHTTPServer.getEventBus().post((Object)notification);
            return;
        }
        if (!latestConsumerGroupConfig.equals(cgm.getConsumerGroupConfig())) {
            ConsumerGroupStateEvent notification = new ConsumerGroupStateEvent();
            notification.action = ConsumerGroupStateEvent.ConsumerGroupStateAction.CHANGE;
            notification.consumerGroup = consumerGroup;
            notification.consumerGroupConfig = EventMeshUtil.cloneObject(latestConsumerGroupConfig);
            this.eventMeshHTTPServer.getEventBus().post((Object)notification);
            return;
        }
    }

    public void shutdown() {
        this.eventMeshHTTPServer.getEventBus().unregister((Object)this);
        for (ConsumerGroupManager consumerGroupManager : this.consumerTable.values()) {
            try {
                consumerGroupManager.shutdown();
            }
            catch (Exception ex) {
                this.logger.error("shutdown consumerGroupManager[{}] err", (Object)consumerGroupManager, (Object)ex);
            }
        }
        this.logger.info("consumerManager shutdown......");
    }

    public boolean contains(String consumerGroup) {
        return this.consumerTable.containsKey(consumerGroup);
    }

    public synchronized void addConsumer(String consumerGroup, ConsumerGroupConf consumerGroupConfig) throws Exception {
        ConsumerGroupManager cgm = new ConsumerGroupManager(this.eventMeshHTTPServer, consumerGroupConfig);
        cgm.init();
        cgm.start();
        this.consumerTable.put(consumerGroup, cgm);
    }

    public synchronized void restartConsumer(String consumerGroup, ConsumerGroupConf consumerGroupConfig) throws Exception {
        if (this.consumerTable.containsKey(consumerGroup)) {
            ConsumerGroupManager cgm = this.consumerTable.get(consumerGroup);
            cgm.refresh(consumerGroupConfig);
        }
    }

    public ConsumerGroupManager getConsumer(String consumerGroup) {
        return this.consumerTable.get(consumerGroup);
    }

    public synchronized void delConsumer(String consumerGroup) throws Exception {
        this.logger.info("start delConsumer with consumerGroup {}", (Object)consumerGroup);
        if (this.consumerTable.containsKey(consumerGroup)) {
            ConsumerGroupManager cgm = this.consumerTable.remove(consumerGroup);
            this.logger.info("start unsubscribe topic with consumer group manager {}", (Object)JsonUtils.serialize((Object)cgm));
            cgm.unsubscribe(consumerGroup);
            cgm.shutdown();
        }
        this.logger.info("end delConsumer with consumerGroup {}", (Object)consumerGroup);
    }

    @Subscribe
    public void onChange(ConsumerGroupTopicConfChangeEvent event) {
        try {
            this.logger.info("onChange event:{}", (Object)event);
            if (event.action == ConsumerGroupTopicConfChangeEvent.ConsumerGroupTopicConfChangeAction.NEW) {
                ConsumerGroupManager manager = this.getConsumer(event.consumerGroup);
                if (Objects.isNull(manager)) {
                    return;
                }
                manager.getConsumerGroupConfig().getConsumerGroupTopicConf().put(event.topic, event.newTopicConf);
                return;
            }
            if (event.action == ConsumerGroupTopicConfChangeEvent.ConsumerGroupTopicConfChangeAction.CHANGE) {
                ConsumerGroupManager manager = this.getConsumer(event.consumerGroup);
                if (Objects.isNull(manager)) {
                    return;
                }
                manager.getConsumerGroupConfig().getConsumerGroupTopicConf().replace(event.topic, event.newTopicConf);
                return;
            }
            if (event.action == ConsumerGroupTopicConfChangeEvent.ConsumerGroupTopicConfChangeAction.DELETE) {
                ConsumerGroupManager manager = this.getConsumer(event.consumerGroup);
                if (Objects.isNull(manager)) {
                    return;
                }
                manager.getConsumerGroupConfig().getConsumerGroupTopicConf().remove(event.topic);
            }
        }
        catch (Exception ex) {
            this.logger.error("onChange event:{} err", (Object)event, (Object)ex);
        }
    }

    @Subscribe
    public void onChange(ConsumerGroupStateEvent event) {
        try {
            this.logger.info("onChange event:{}", (Object)event);
            if (event.action == ConsumerGroupStateEvent.ConsumerGroupStateAction.NEW) {
                this.addConsumer(event.consumerGroup, event.consumerGroupConfig);
                return;
            }
            if (event.action == ConsumerGroupStateEvent.ConsumerGroupStateAction.CHANGE) {
                this.restartConsumer(event.consumerGroup, event.consumerGroupConfig);
                return;
            }
            if (event.action == ConsumerGroupStateEvent.ConsumerGroupStateAction.DELETE) {
                this.delConsumer(event.consumerGroup);
                return;
            }
        }
        catch (Exception ex) {
            this.logger.error("onChange event:{} err", (Object)event, (Object)ex);
        }
    }

    public ConcurrentHashMap<String, ConsumerGroupManager> getClientTable() {
        return this.consumerTable;
    }
}

