/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.retry;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.protocol.grpc.retry.DelayRetryable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcRetryer {
    private Logger retryLogger = LoggerFactory.getLogger((String)"retry");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventMeshGrpcConfiguration grpcConfiguration;
    private DelayQueue<DelayRetryable> failed = new DelayQueue();
    private ThreadPoolExecutor pool;
    private Thread dispatcher;

    public GrpcRetryer(EventMeshGrpcServer eventMeshGrpcServer) {
        this.grpcConfiguration = eventMeshGrpcServer.getEventMeshGrpcConfiguration();
    }

    public void pushRetry(DelayRetryable delayRetryable) {
        if (this.failed.size() >= this.grpcConfiguration.eventMeshServerRetryBlockQueueSize) {
            this.retryLogger.error("[RETRY-QUEUE] is full!");
            return;
        }
        this.failed.offer(delayRetryable);
    }

    public void init() {
        this.pool = new ThreadPoolExecutor(this.grpcConfiguration.eventMeshServerRetryThreadNum, this.grpcConfiguration.eventMeshServerRetryThreadNum, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.grpcConfiguration.eventMeshServerRetryBlockQueueSize), new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "grpc-retry-" + this.count.incrementAndGet());
                thread.setPriority(5);
                thread.setDaemon(true);
                return thread;
            }
        }, new ThreadPoolExecutor.AbortPolicy());
        this.dispatcher = new Thread(() -> {
            try {
                DelayRetryable retryObj = null;
                while (!Thread.currentThread().isInterrupted() && (retryObj = (DelayRetryable)this.failed.take()) != null) {
                    DelayRetryable delayRetryable = retryObj;
                    this.pool.execute(() -> {
                        try {
                            delayRetryable.retry();
                            if (this.retryLogger.isDebugEnabled()) {
                                this.retryLogger.debug("retryObj : {}", (Object)delayRetryable);
                            }
                        }
                        catch (Exception e) {
                            this.retryLogger.error("grpc-retry-dispatcher error!", (Throwable)e);
                        }
                    });
                }
            }
            catch (Exception e) {
                this.retryLogger.error("grpc-retry-dispatcher error!", (Throwable)e);
            }
        }, "grpc-retry-dispatcher");
        this.dispatcher.setDaemon(true);
        this.logger.info("GrpcRetryer inited......");
    }

    public int size() {
        return this.failed.size();
    }

    public void shutdown() {
        this.dispatcher.interrupt();
        this.pool.shutdown();
        this.logger.info("GrpcRetryer shutdown......");
    }

    public void start() throws Exception {
        this.dispatcher.start();
        this.logger.info("GrpcRetryer started......");
    }
}

