/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.push;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.AbstractPushRequest;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.StreamPushRequest;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.WebhookPushRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHandler.class);
    private static final ScheduledExecutorService SCHEDULER = ThreadPoolFactory.createSingleScheduledExecutor((String)"eventMesh-pushMsgTimeout-");
    private final ThreadPoolExecutor pushExecutor;
    private static final Integer CONSUMER_GROUP_WAITING_REQUEST_THRESHOLD = 10000;
    private static final Map<String, Set<AbstractPushRequest>> waitingRequests = Maps.newConcurrentMap();

    public MessageHandler(String consumerGroup, ThreadPoolExecutor pushMsgExecutor) {
        this.pushExecutor = pushMsgExecutor;
        waitingRequests.put(consumerGroup, Sets.newConcurrentHashSet());
        SCHEDULER.scheduleAtFixedRate(this::checkTimeout, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void checkTimeout() {
        waitingRequests.forEach((key, value) -> {
            for (AbstractPushRequest request : value) {
                request.timeout();
                waitingRequests.get(request.getHandleMsgContext().getConsumerGroup()).remove(request);
            }
        });
    }

    public boolean handle(HandleMsgContext handleMsgContext) {
        Set waitingRequests4Group = (Set)MapUtils.getObject(waitingRequests, (Object)handleMsgContext.getConsumerGroup(), (Object)Sets.newConcurrentHashSet());
        if (waitingRequests4Group.size() > CONSUMER_GROUP_WAITING_REQUEST_THRESHOLD) {
            LOGGER.warn("waitingRequests is too many, so reject, this message will be send back to MQ, consumerGroup:{}, threshold:{}", (Object)handleMsgContext.getConsumerGroup(), (Object)CONSUMER_GROUP_WAITING_REQUEST_THRESHOLD);
            return false;
        }
        try {
            this.pushExecutor.submit(() -> {
                AbstractPushRequest pushRequest = this.createGrpcPushRequest(handleMsgContext);
                pushRequest.tryPushRequest();
            });
            return true;
        }
        catch (RejectedExecutionException e) {
            return false;
        }
    }

    private AbstractPushRequest createGrpcPushRequest(HandleMsgContext handleMsgContext) {
        GrpcType grpcType = handleMsgContext.getGrpcType();
        if (GrpcType.WEBHOOK == grpcType) {
            return new WebhookPushRequest(handleMsgContext, waitingRequests);
        }
        return new StreamPushRequest(handleMsgContext, waitingRequests);
    }
}

