/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTopicConfig
extends ConsumerGroupTopicConfig {
    private static final Logger log = LoggerFactory.getLogger(StreamTopicConfig.class);
    private final transient Map<String, Map<String, EventEmitter<SimpleMessage>>> idcEmitterMap = new ConcurrentHashMap<String, Map<String, EventEmitter<SimpleMessage>>>();
    private transient Map<String, List<EventEmitter<SimpleMessage>>> idcEmitters = new ConcurrentHashMap<String, List<EventEmitter<SimpleMessage>>>();
    private transient List<EventEmitter<SimpleMessage>> totalEmitters = new ArrayList<EventEmitter<SimpleMessage>>();

    public StreamTopicConfig(String consumerGroup, String topic, Subscription.SubscriptionItem.SubscriptionMode subscriptionMode) {
        super(consumerGroup, topic, subscriptionMode, GrpcType.STREAM);
    }

    @Override
    public synchronized void registerClient(ConsumerGroupClient client) {
        Objects.requireNonNull(client, "ConsumerGroupClient can not be null");
        if (client.getGrpcType() != this.grpcType) {
            if (log.isWarnEnabled()) {
                log.warn("Invalid grpc type: {}, expecting grpc type: {}, can not register client {}", new Object[]{client.getGrpcType(), this.grpcType, client});
            }
            return;
        }
        this.idcEmitterMap.computeIfAbsent(client.getIdc(), k -> new HashMap()).put(client.getIp() + ":" + client.getPid(), client.getEventEmitter());
        this.idcEmitters = StreamTopicConfig.buildIdcEmitter(this.idcEmitterMap);
        this.totalEmitters = StreamTopicConfig.buildTotalEmitter(this.idcEmitters);
    }

    @Override
    public void deregisterClient(ConsumerGroupClient client) {
        String idc = client.getIdc();
        String clientIp = client.getIp();
        String clientPid = client.getPid();
        Map<String, EventEmitter<SimpleMessage>> emitters = this.idcEmitterMap.get(idc);
        if (MapUtils.isEmpty(emitters)) {
            return;
        }
        emitters.remove(clientIp + ":" + clientPid);
        if (emitters.isEmpty()) {
            this.idcEmitterMap.remove(idc);
        }
        this.idcEmitters = StreamTopicConfig.buildIdcEmitter(this.idcEmitterMap);
        this.totalEmitters = StreamTopicConfig.buildTotalEmitter(this.idcEmitters);
    }

    @Override
    public int getSize() {
        return this.totalEmitters.size();
    }

    public String toString() {
        return "StreamConsumeTopicConfig={consumerGroup=" + this.consumerGroup + ",grpcType=" + (Object)((Object)this.grpcType) + ",topic=" + this.topic + "}";
    }

    public Map<String, List<EventEmitter<SimpleMessage>>> getIdcEmitters() {
        return this.idcEmitters;
    }

    public List<EventEmitter<SimpleMessage>> getTotalEmitters() {
        return this.totalEmitters;
    }

    private static Map<String, List<EventEmitter<SimpleMessage>>> buildIdcEmitter(Map<String, Map<String, EventEmitter<SimpleMessage>>> idcEmitterMap) {
        HashMap<String, List<EventEmitter<SimpleMessage>>> result = new HashMap<String, List<EventEmitter<SimpleMessage>>>();
        idcEmitterMap.forEach((k, v) -> result.put((String)k, new LinkedList(v.values())));
        return result;
    }

    private static List<EventEmitter<SimpleMessage>> buildTotalEmitter(Map<String, List<EventEmitter<SimpleMessage>>> idcEmitters) {
        LinkedList<EventEmitter<SimpleMessage>> emitterList = new LinkedList<EventEmitter<SimpleMessage>>();
        idcEmitters.values().forEach(emitterList::addAll);
        return emitterList;
    }
}

