/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.plugin;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.admin.Admin;
import org.apache.eventmesh.api.admin.TopicProperties;
import org.apache.eventmesh.api.factory.ConnectorPluginFactory;
import org.apache.eventmesh.runtime.core.plugin.MQWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQAdminWrapper
extends MQWrapper {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Admin meshMQAdmin;

    public MQAdminWrapper(String connectorPluginType) {
        this.meshMQAdmin = ConnectorPluginFactory.getMeshMQAdmin((String)connectorPluginType);
        if (this.meshMQAdmin == null) {
            this.logger.error("can't load the meshMQAdmin plugin, please check.");
            throw new RuntimeException("doesn't load the meshMQAdmin plugin, please check.");
        }
    }

    public synchronized void init(Properties keyValue) throws Exception {
        if (this.inited.get()) {
            return;
        }
        this.meshMQAdmin.init(keyValue);
        this.inited.compareAndSet(false, true);
    }

    public synchronized void start() throws Exception {
        if (this.started.get()) {
            return;
        }
        this.meshMQAdmin.start();
        this.started.compareAndSet(false, true);
    }

    public synchronized void shutdown() throws Exception {
        if (!this.inited.get()) {
            return;
        }
        if (!this.started.get()) {
            return;
        }
        this.meshMQAdmin.shutdown();
        this.inited.compareAndSet(true, false);
        this.started.compareAndSet(true, false);
    }

    public Admin getMeshMQAdmin() {
        return this.meshMQAdmin;
    }

    public List<TopicProperties> getTopic() throws Exception {
        return this.meshMQAdmin.getTopic();
    }

    public void createTopic(String topicName) throws Exception {
        this.meshMQAdmin.createTopic(topicName);
    }

    public void deleteTopic(String topicName) throws Exception {
        this.meshMQAdmin.deleteTopic(topicName);
    }

    public List<CloudEvent> getEvent(String topicName, int offset, int length) throws Exception {
        return this.meshMQAdmin.getEvent(topicName, offset, length);
    }

    public void publish(CloudEvent cloudEvent) throws Exception {
        this.meshMQAdmin.publish(cloudEvent);
    }
}

