/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshStartup {
    public static final Logger LOGGER = LoggerFactory.getLogger(EventMeshStartup.class);

    public static void main(String[] args) throws Exception {
        try {
            EventMeshServer server = new EventMeshServer(new ConfigurationWrapper(EventMeshConstants.EVENTMESH_CONF_HOME, "eventmesh.properties", false));
            server.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("eventMesh shutting down hook begin.");
                    }
                    long start = System.currentTimeMillis();
                    server.shutdown();
                    long end = System.currentTimeMillis();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("eventMesh shutdown cost {}ms", (Object)(end - start));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("exception when shutdown.", (Throwable)e);
                }
            }));
        }
        catch (Throwable e) {
            LOGGER.error("EventMesh start fail.", e);
            System.exit(-1);
        }
    }
}

