/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/clientManage/showClientBySystem")
public class ShowClientBySystemHandler
extends AbstractHttpHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowClientBySystemHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public ShowClientBySystemHandler(EventMeshTCPServer eventMeshTCPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        StringBuilder result = new StringBuilder();
        try (OutputStream out = httpExchange.getResponseBody();){
            ClientSessionGroupMapping clientSessionGroupMapping;
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap;
            String queryString = httpExchange.getRequestURI().getQuery();
            Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
            String subSystem = (String)queryStringInfo.get("subsystem");
            String newLine = System.getProperty("line.separator");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("showClientBySubsys,subsys:{}", (Object)subSystem);
            }
            if ((sessionMap = (clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping()).getSessionMap()) != null && !sessionMap.isEmpty()) {
                for (Session session : sessionMap.values()) {
                    if (!session.getClient().getSubsystem().equals(subSystem)) continue;
                    UserAgent userAgent = session.getClient();
                    result.append(String.format("pid=%s | ip=%s | port=%s | path=%s | purpose=%s", userAgent.getPid(), userAgent.getHost(), userAgent.getPort(), userAgent.getPath(), userAgent.getPurpose())).append(newLine);
                }
            }
            NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
            out.write(result.toString().getBytes(Constants.DEFAULT_CHARSET));
        }
    }
}

