/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/clientManage/rejectClientBySubSystem")
public class RejectClientBySubSystemHandler
extends AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(RejectClientBySubSystemHandler.class);
    private final transient EventMeshTCPServer eventMeshTCPServer;

    public RejectClientBySubSystemHandler(EventMeshTCPServer eventMeshTCPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    private String printClients(List<InetSocketAddress> clients) {
        if (clients == null || clients.isEmpty()) {
            return "no session had been closed";
        }
        StringBuilder sb = new StringBuilder();
        for (InetSocketAddress addr : clients) {
            sb.append(addr).append("|");
        }
        return sb.toString();
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try (OutputStream out = httpExchange.getResponseBody();){
            String queryString = httpExchange.getRequestURI().getQuery();
            Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
            String subSystem = (String)queryStringInfo.get("subsystem");
            if (StringUtils.isBlank((CharSequence)subSystem)) {
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                String result = "params illegal!";
                out.write(result.getBytes(Constants.DEFAULT_CHARSET));
                return;
            }
            log.info("rejectClientBySubSystem in admin,subsys:{}====================", (Object)subSystem);
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            ArrayList<InetSocketAddress> successRemoteAddrs = new ArrayList<InetSocketAddress>();
            try {
                if (!sessionMap.isEmpty()) {
                    for (Session session : sessionMap.values()) {
                        InetSocketAddress addr;
                        if (!session.getClient().getSubsystem().equals(subSystem) || (addr = EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer, session, clientSessionGroupMapping)) == null) continue;
                        successRemoteAddrs.add(addr);
                    }
                }
            }
            catch (Exception e) {
                log.error("clientManage|rejectClientBySubSystem|fail|subSystemId={},errMsg={}", (Object)subSystem, (Object)e);
                String result = String.format("rejectClientBySubSystem fail! sessionMap size {%d}, had reject {%s} , {subSystemId=%s}, errorMsg : %s", sessionMap.size(), this.printClients(successRemoteAddrs), subSystem, e.getMessage());
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                out.write(result.getBytes(Constants.DEFAULT_CHARSET));
                if (out != null) {
                    if (var4_4 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
                return;
            }
            String result = String.format("rejectClientBySubSystem success! sessionMap size {%d}, had reject {%s} , {subSystemId=%s}", sessionMap.size(), this.printClients(successRemoteAddrs), subSystem);
            NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            log.error("rejectClientBySubSystem fail...", (Throwable)e);
        }
    }
}

