/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.provider.EventFormatProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.handler.ConfigurationHandler;
import org.apache.eventmesh.runtime.admin.response.Error;
import org.apache.eventmesh.runtime.admin.utils.HttpExchangeUtils;
import org.apache.eventmesh.runtime.admin.utils.JsonUtils;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.plugin.MQAdminWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/event")
public class EventHandler
extends AbstractHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationHandler.class);
    private final MQAdminWrapper admin;

    public EventHandler(String connectorPluginType, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.admin = new MQAdminWrapper(connectorPluginType);
        try {
            this.admin.init(null);
        }
        catch (Exception ignored) {
            logger.info("failed to initialize MQAdminWrapper");
        }
    }

    void preflight(HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Methods", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Headers", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Max-Age", "86400");
        httpExchange.sendResponseHeaders(200, 0L);
        OutputStream out = httpExchange.getResponseBody();
        out.close();
    }

    private Map<String, String> queryToMap(String query) {
        if (query == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : query.split("&")) {
            String[] entry = param.split("=");
            if (entry.length > 1) {
                result.put(entry[0], entry[1]);
                continue;
            }
            result.put(entry[0], "");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void get(HttpExchange httpExchange) throws IOException {
        OutputStream out = httpExchange.getResponseBody();
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        try {
            String queryString = httpExchange.getRequestURI().getQuery();
            if (queryString == null || queryString.equals("")) {
                httpExchange.sendResponseHeaders(401, 0L);
                out.close();
                return;
            }
            Map<String, String> queryMap = this.queryToMap(queryString);
            String topicName = queryMap.get("topicName");
            int offset = Integer.parseInt(queryMap.get("offset"));
            int length = Integer.parseInt(queryMap.get("length"));
            List<CloudEvent> eventList = this.admin.getEvent(topicName, offset, length);
            ArrayList<String> eventJsonList = new ArrayList<String>();
            for (CloudEvent event : eventList) {
                byte[] serializedEvent = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json").serialize(event);
                eventJsonList.add(new String(serializedEvent, StandardCharsets.UTF_8));
            }
            String result = JsonUtils.toJson(eventJsonList);
            httpExchange.sendResponseHeaders(200, result.getBytes().length);
            out.write(result.getBytes());
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            String stackTrace = writer.toString();
            Error error = new Error(e.toString(), stackTrace);
            String result = JsonUtils.toJson(error);
            httpExchange.sendResponseHeaders(500, result.getBytes().length);
            out.write(result.getBytes());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void post(HttpExchange httpExchange) throws IOException {
        OutputStream out = httpExchange.getResponseBody();
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        try {
            String request = HttpExchangeUtils.streamToString(httpExchange.getRequestBody());
            byte[] rawRequest = request.getBytes(StandardCharsets.UTF_8);
            CloudEvent event = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json").deserialize(rawRequest);
            this.admin.publish(event);
            httpExchange.sendResponseHeaders(200, 0L);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            String stackTrace = writer.toString();
            Error error = new Error(e.toString(), stackTrace);
            String result = JsonUtils.toJson(error);
            httpExchange.sendResponseHeaders(500, result.getBytes().length);
            out.write(result.getBytes());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        if (httpExchange.getRequestMethod().equals("OPTIONS")) {
            this.preflight(httpExchange);
        }
        if (httpExchange.getRequestMethod().equals("POST")) {
            this.post(httpExchange);
        }
        if (httpExchange.getRequestMethod().equals("GET")) {
            this.get(httpExchange);
        }
    }
}

