/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.jaeger.config;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaegerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JaegerConfiguration.class);
    private static final String CONFIG_FILE = "jaeger.properties";
    private static final Properties PROPERTIES = new Properties();
    private static String eventMeshJaegerIp = "localhost";
    private static int eventMeshJaegerPort = 14250;

    private static void loadProperties() {
        URL resource = JaegerConfiguration.class.getClassLoader().getResource(CONFIG_FILE);
        if (resource != null) {
            try (InputStream inputStream = resource.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                if (inputStream.available() > 0) {
                    PROPERTIES.load(reader);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Load jaeger.properties file from classpath error", e);
            }
        }
        try {
            String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + CONFIG_FILE;
            PropertiesUtils.loadPropertiesWhenFileExist((Properties)PROPERTIES, (String)configPath);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load jaeger.properties file from conf", e);
        }
    }

    private static void initializeConfig() {
        String jaegerIp = PROPERTIES.getProperty("eventmesh.trace.jaeger.ip");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)jaegerIp), (Object)String.format("%s error", "eventmesh.trace.jaeger.ip"));
        eventMeshJaegerIp = StringUtils.deleteWhitespace((String)jaegerIp);
        String jaegerPort = PROPERTIES.getProperty("eventmesh.trace.jaeger.port");
        if (StringUtils.isNotEmpty((CharSequence)jaegerPort)) {
            eventMeshJaegerPort = Integer.parseInt(StringUtils.deleteWhitespace((String)jaegerPort));
        }
    }

    public static String getEventMeshJaegerIp() {
        return eventMeshJaegerIp;
    }

    public static int getEventMeshJaegerPort() {
        return eventMeshJaegerPort;
    }

    private JaegerConfiguration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        JaegerConfiguration.loadProperties();
        JaegerConfiguration.initializeConfig();
    }
}

