/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.jaeger;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.eventmesh.trace.api.EventMeshTraceService;
import org.apache.eventmesh.trace.api.config.ExporterConfiguration;
import org.apache.eventmesh.trace.api.exception.TraceException;
import org.apache.eventmesh.trace.jaeger.config.JaegerConfiguration;

public class JaegerTraceService
implements EventMeshTraceService {
    private String eventMeshJaegerIp;
    private int eventMeshJaegerPort;
    private int eventMeshTraceExportInterval;
    private int eventMeshTraceExportTimeout;
    private int eventMeshTraceMaxExportSize;
    private int eventMeshTraceMaxQueueSize;
    protected SdkTracerProvider sdkTracerProvider;
    protected OpenTelemetry openTelemetry;
    protected Thread shutdownHook;
    private Tracer tracer;
    private TextMapPropagator textMapPropagator;

    public void init() throws TraceException {
        this.eventMeshJaegerIp = JaegerConfiguration.getEventMeshJaegerIp();
        this.eventMeshJaegerPort = JaegerConfiguration.getEventMeshJaegerPort();
        this.eventMeshTraceExportInterval = ExporterConfiguration.getEventMeshTraceExportInterval();
        this.eventMeshTraceExportTimeout = ExporterConfiguration.getEventMeshTraceExportTimeout();
        this.eventMeshTraceMaxExportSize = ExporterConfiguration.getEventMeshTraceMaxExportSize();
        this.eventMeshTraceMaxQueueSize = ExporterConfiguration.getEventMeshTraceMaxQueueSize();
        String httpEndpoint = String.format("http://%s:%s", this.eventMeshJaegerIp, this.eventMeshJaegerPort);
        JaegerGrpcSpanExporter jaegerExporter = JaegerGrpcSpanExporter.builder().setEndpoint(httpEndpoint).build();
        BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder((SpanExporter)jaegerExporter).setScheduleDelay((long)this.eventMeshTraceExportInterval, TimeUnit.SECONDS).setExporterTimeout((long)this.eventMeshTraceExportTimeout, TimeUnit.SECONDS).setMaxExportBatchSize(this.eventMeshTraceMaxExportSize).setMaxQueueSize(this.eventMeshTraceMaxQueueSize).build();
        Resource serviceNameResource = Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"eventmesh_trace"));
        this.sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)spanProcessor).setResource(Resource.getDefault().merge(serviceNameResource)).build();
        this.openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(this.sdkTracerProvider).build();
        this.tracer = this.openTelemetry.getTracer("eventmesh_trace");
        this.textMapPropagator = this.openTelemetry.getPropagators().getTextMapPropagator();
        this.shutdownHook = new Thread(() -> ((SdkTracerProvider)this.sdkTracerProvider).close());
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public Context extractFrom(Context context, Map<String, Object> carrier) throws TraceException {
        this.textMapPropagator.extract(context, carrier, (TextMapGetter)new TextMapGetter<Map<String, Object>>(){

            public Iterable<String> keys(Map<String, Object> carrier) {
                return carrier.keySet();
            }

            @Nullable
            public String get(@Nullable Map<String, Object> carrier, String key) {
                return Optional.ofNullable(carrier.get(key)).map(Objects::toString).orElse(null);
            }
        });
        return context;
    }

    public void inject(Context context, Map<String, Object> carrier) {
        this.textMapPropagator.inject(context, carrier, (cr, key, value) -> {
            if (cr != null) {
                cr.put(key, value);
            }
        });
    }

    public Span createSpan(String spanName, SpanKind spanKind, long startTimestamp, TimeUnit timeUnit, Context context, boolean isSpanFinishInOtherThread) throws TraceException {
        return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(spanKind).setStartTimestamp(startTimestamp, timeUnit).startSpan();
    }

    public Span createSpan(String spanName, SpanKind spanKind, Context context, boolean isSpanFinishInOtherThread) throws TraceException {
        return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(spanKind).setStartTimestamp(System.currentTimeMillis(), TimeUnit.MILLISECONDS).startSpan();
    }

    public void shutdown() throws TraceException {
        this.sdkTracerProvider.close();
    }
}

