/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.registry.nacos.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.NacosNamingService;
import com.alibaba.nacos.common.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.RegistryException;
import org.apache.eventmesh.api.registry.RegistryService;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRegistryService
implements RegistryService {
    private static final Logger logger = LoggerFactory.getLogger(NacosRegistryService.class);
    private static final AtomicBoolean INIT_STATUS = new AtomicBoolean(false);
    private static final AtomicBoolean START_STATUS = new AtomicBoolean(false);
    private String serverAddr;
    private String username;
    private String password;
    private NamingService namingService;
    private Map<String, EventMeshRegisterInfo> eventMeshRegisterInfoMap;

    public void init() throws RegistryException {
        boolean update = INIT_STATUS.compareAndSet(false, true);
        if (!update) {
            return;
        }
        this.eventMeshRegisterInfoMap = new HashMap<String, EventMeshRegisterInfo>(ConfigurationContextUtil.KEYS.size());
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
            if (null == commonConfiguration) continue;
            if (StringUtils.isBlank((CharSequence)commonConfiguration.getNamesrvAddr())) {
                throw new RegistryException("namesrvAddr cannot be null");
            }
            this.serverAddr = commonConfiguration.getNamesrvAddr();
            this.username = commonConfiguration.getEventMeshRegistryPluginUsername();
            this.password = commonConfiguration.getEventMeshRegistryPluginPassword();
            break;
        }
    }

    public void start() throws RegistryException {
        boolean update = START_STATUS.compareAndSet(false, true);
        if (!update) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("serverAddr", this.serverAddr);
            properties.setProperty("username", this.username);
            properties.setProperty("password", this.password);
            this.namingService = new NacosNamingService(properties);
        }
        catch (NacosException e) {
            logger.error("[NacosRegistryService][start] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
    }

    public void shutdown() throws RegistryException {
        INIT_STATUS.compareAndSet(true, false);
        START_STATUS.compareAndSet(true, false);
        try {
            this.namingService.shutDown();
        }
        catch (NacosException e) {
            logger.error("[NacosRegistryService][shutdown] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        logger.info("NacosRegistryService close");
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws RegistryException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration configuration = ConfigurationContextUtil.get((String)key);
            if (Objects.isNull(configuration)) continue;
            String eventMeshName = configuration.getEventMeshName();
            try {
                List instances = this.namingService.selectInstances(eventMeshName + "-" + key, configuration.getEventMeshCluster(), Collections.singletonList(clusterName), true);
                if (CollectionUtils.isEmpty((Collection)instances)) continue;
                for (Instance instance : instances) {
                    EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(instance.getClusterName(), instance.getServiceName(), instance.getIp() + ":" + instance.getPort(), 0L, instance.getMetadata());
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
            catch (NacosException e) {
                logger.error("[NacosRegistryService][findEventMeshInfoByCluster] error", (Throwable)e);
                throw new RegistryException(e.getMessage());
            }
        }
        return eventMeshDataInfoList;
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws RegistryException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration configuration = ConfigurationContextUtil.get((String)key);
            if (Objects.isNull(configuration)) continue;
            String eventMeshName = configuration.getEventMeshName();
            try {
                List instances = this.namingService.selectInstances(eventMeshName + "-" + key, key + "-" + "GROUP", null, true);
                if (CollectionUtils.isEmpty((Collection)instances)) continue;
                for (Instance instance : instances) {
                    EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(instance.getClusterName(), instance.getServiceName(), instance.getIp() + ":" + instance.getPort(), 0L, instance.getMetadata());
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
            catch (NacosException e) {
                logger.error("[NacosRegistryService][findEventMeshInfoByCluster] error", (Throwable)e);
                throw new RegistryException(e.getMessage());
            }
        }
        return eventMeshDataInfoList;
    }

    public Map<String, Map<String, Integer>> findEventMeshClientDistributionData(String clusterName, String group, String purpose) throws RegistryException {
        return null;
    }

    public void registerMetadata(Map<String, String> metadataMap) {
        for (Map.Entry<String, EventMeshRegisterInfo> eventMeshRegisterInfo : this.eventMeshRegisterInfoMap.entrySet()) {
            EventMeshRegisterInfo registerInfo = eventMeshRegisterInfo.getValue();
            registerInfo.setMetadata(metadataMap);
            this.register(registerInfo);
        }
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws RegistryException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getEndPoint().split(":");
            String eventMeshClusterName = eventMeshRegisterInfo.getEventMeshClusterName();
            Map metadata = eventMeshRegisterInfo.getMetadata();
            Instance instance = new Instance();
            instance.setIp(ipPort[0]);
            instance.setPort(Integer.parseInt(ipPort[1]));
            instance.setWeight(1.0);
            instance.setClusterName(eventMeshClusterName);
            instance.setMetadata(metadata);
            String eventMeshName = eventMeshRegisterInfo.getEventMeshName();
            this.namingService.registerInstance(eventMeshName, eventMeshRegisterInfo.getProtocolType() + "-" + "GROUP", instance);
            this.eventMeshRegisterInfoMap.put(eventMeshName, eventMeshRegisterInfo);
        }
        catch (NacosException e) {
            logger.error("[NacosRegistryService][register] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        logger.info("EventMesh successfully registered to nacos");
        return true;
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws RegistryException {
        String[] ipPort = eventMeshUnRegisterInfo.getEndPoint().split(":");
        try {
            Instance instance = new Instance();
            instance.setIp(ipPort[0]);
            instance.setPort(Integer.parseInt(ipPort[1]));
            String eventMeshName = eventMeshUnRegisterInfo.getEventMeshName();
            String eventMeshClusterName = eventMeshUnRegisterInfo.getEventMeshClusterName();
            instance.setClusterName(eventMeshClusterName);
            this.namingService.deregisterInstance(eventMeshName, eventMeshUnRegisterInfo.getProtocolType() + "-" + "GROUP", instance);
        }
        catch (NacosException e) {
            logger.error("[NacosRegistryService][unRegister] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        logger.info("EventMesh successfully logout to nacos");
        return true;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public NamingService getNamingService() {
        return this.namingService;
    }
}

