/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.spi.loader;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.eventmesh.spi.EventMeshSPI;
import org.apache.eventmesh.spi.ExtensionException;
import org.apache.eventmesh.spi.loader.EventMeshUrlClassLoader;
import org.apache.eventmesh.spi.loader.ExtensionClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarExtensionClassLoader
implements ExtensionClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(JarExtensionClassLoader.class);
    private static final String EVENT_MESH_PLUGIN_DIR = "eventMeshPluginDir";
    private static final ConcurrentHashMap<Class<?>, Map<String, Class<?>>> EXTENSION_CLASS_CACHE = new ConcurrentHashMap(16);
    private static final String EVENTMESH_EXTENSION_PLUGIN_DIR = System.getProperty("eventMeshPluginDir", Joiner.on((String)File.separator).join((Iterable)Lists.newArrayList((Object[])new String[]{".", "plugin"})));

    @Override
    public <T> Map<String, Class<?>> loadExtensionClass(Class<T> extensionType, String extensionInstanceName) {
        return EXTENSION_CLASS_CACHE.computeIfAbsent(extensionType, t -> this.doLoadExtensionClass((Class)t, extensionInstanceName));
    }

    private <T> Map<String, Class<?>> doLoadExtensionClass(Class<T> extensionType, String extensionInstanceName) {
        HashMap extensionMap = new HashMap(16);
        EventMeshSPI eventMeshSpiAnnotation = extensionType.getAnnotation(EventMeshSPI.class);
        String pluginDir = Paths.get(EVENTMESH_EXTENSION_PLUGIN_DIR, eventMeshSpiAnnotation.eventMeshExtensionType().getExtensionTypeName(), extensionInstanceName).toString();
        String extensionFileName = "META-INF/eventmesh/" + extensionType.getName();
        EventMeshUrlClassLoader urlClassLoader = EventMeshUrlClassLoader.getInstance();
        urlClassLoader.addUrls(this.loadJarPathFromResource(pluginDir));
        try {
            Enumeration<URL> extensionUrls = urlClassLoader.getResources(extensionFileName);
            if (extensionUrls != null) {
                while (extensionUrls.hasMoreElements()) {
                    URL url = extensionUrls.nextElement();
                    extensionMap.putAll(JarExtensionClassLoader.loadResources(urlClassLoader, url, extensionType));
                }
            }
        }
        catch (IOException e) {
            throw new ExtensionException("load extension class error", e);
        }
        return extensionMap;
    }

    private List<URL> loadJarPathFromResource(String pluginPath) {
        File plugin = new File(pluginPath);
        if (!plugin.exists()) {
            logger.warn("plugin dir:{} is not exist", (Object)pluginPath);
            return Lists.newArrayList();
        }
        if (plugin.isFile() && plugin.getName().endsWith(".jar")) {
            try {
                return Lists.newArrayList((Object[])new URL[]{plugin.toURI().toURL()});
            }
            catch (Exception e) {
                throw new ExtensionException(e);
            }
        }
        File[] files = plugin.listFiles();
        ArrayList<URL> pluginUrls = new ArrayList<URL>();
        if (files != null) {
            for (File file : files) {
                pluginUrls.addAll(this.loadJarPathFromResource(file.getPath()));
            }
        }
        pluginUrls.sort(Comparator.comparing(URL::getPath));
        return pluginUrls;
    }

    private static <T> Map<String, Class<?>> loadResources(URLClassLoader urlClassLoader, URL url, Class<T> extensionType) throws IOException {
        HashMap extensionMap = new HashMap();
        try (InputStream inputStream = url.openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(extensionName, extensionClass) -> {
                String extensionNameStr = (String)extensionName;
                String extensionClassStr = (String)extensionClass;
                try {
                    Class<?> targetClass = urlClassLoader.loadClass(extensionClassStr);
                    logger.info("load extension class success, extensionType: {}, extensionClass: {}", (Object)extensionType, targetClass);
                    if (!extensionType.isAssignableFrom(targetClass)) {
                        throw new ExtensionException(String.format("class: %s is not subClass of %s", targetClass, extensionType));
                    }
                    extensionMap.put(extensionNameStr, targetClass);
                }
                catch (ClassNotFoundException e) {
                    throw new ExtensionException("load extension class error", e);
                }
            }));
        }
        return extensionMap;
    }
}

