/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrometheusConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PrometheusConfiguration.class);
    private static final String CONFIG_FILE = "prometheus.properties";
    private static final Properties properties = new Properties();
    private static int eventMeshPrometheusPort = 19090;

    public static int getEventMeshPrometheusPort() {
        return eventMeshPrometheusPort;
    }

    private static void initializeConfig() {
        String eventMeshPrometheusPortStr = properties.getProperty("eventMesh.metrics.prometheus.port");
        if (StringUtils.isNotEmpty((CharSequence)eventMeshPrometheusPortStr)) {
            eventMeshPrometheusPort = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshPrometheusPortStr));
        }
    }

    private static void loadProperties() {
        try (InputStream resourceAsStream = PrometheusConfiguration.class.getResourceAsStream(File.separator + CONFIG_FILE);){
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Load %s file from classpath error", CONFIG_FILE));
        }
        try {
            String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + CONFIG_FILE;
            PropertiesUtils.loadPropertiesWhenFileExist((Properties)properties, (String)configPath);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot load %s file from conf", CONFIG_FILE));
        }
    }

    private PrometheusConfiguration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        PrometheusConfiguration.loadProperties();
        PrometheusConfiguration.initializeConfig();
    }
}

