/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.util;

import com.navercorp.pinpoint.common.util.Assert;
import java.util.concurrent.atomic.AtomicInteger;

public class IDGenerator {
    private final AtomicInteger idGenerator;
    private final int gap;

    public IDGenerator() {
        this(1, 1);
    }

    public IDGenerator(int startIndex) {
        this(startIndex, 1);
    }

    public IDGenerator(int startIndex, int gap) {
        Assert.isTrue((startIndex >= 0 ? 1 : 0) != 0, (String)"StartIndex must be grater than or equal to 0.");
        Assert.isTrue((gap > 0 ? 1 : 0) != 0, (String)"Gap must be grater than 0.");
        this.gap = gap;
        this.idGenerator = new AtomicInteger(startIndex);
    }

    public int generate() {
        return this.idGenerator.getAndAdd(this.gap);
    }

    public int get() {
        return this.idGenerator.get();
    }

    public static IDGenerator createOddIdGenerator() {
        return new IDGenerator(1, 2);
    }

    public static IDGenerator createEvenIdGenerator() {
        return new IDGenerator(2, 2);
    }
}

