/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class WriteFailFutureListener
implements ChannelFutureListener {
    private final Logger logger;
    private final String failMessage;
    private final String successMessage;

    public WriteFailFutureListener(Logger logger, String failMessage) {
        this(logger, failMessage, null);
    }

    public WriteFailFutureListener(Logger logger, String failMessage, String successMessage) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.failMessage = failMessage;
        this.successMessage = successMessage;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (!future.isSuccess()) {
            if (this.logger.isWarnEnabled()) {
                Throwable cause = future.getCause();
                this.logger.warn("{} channel:{} Caused:{}", (Object)this.failMessage, (Object)future.getChannel(), (Object)cause.getMessage(), (Object)cause);
            }
        } else if (this.successMessage != null && this.logger.isDebugEnabled()) {
            this.logger.debug("{} channel:{}", (Object)this.successMessage, (Object)future.getChannel());
        }
    }
}

