/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.rpc.DefaultFuture;
import com.navercorp.pinpoint.rpc.Future;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.PinpointClientReconnectEventListener;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelEventHandler;
import com.navercorp.pinpoint.rpc.stream.StreamException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultPinpointClient
implements PinpointClient {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private volatile PinpointClientHandler pinpointClientHandler;
    private volatile boolean closed;
    private final List<PinpointClientReconnectEventListener> reconnectEventListeners = new CopyOnWriteArrayList<PinpointClientReconnectEventListener>();

    public DefaultPinpointClient(PinpointClientHandler pinpointClientHandler) {
        this.pinpointClientHandler = Objects.requireNonNull(pinpointClientHandler, "pinpointClientHandler");
        pinpointClientHandler.setPinpointClient(this);
    }

    @Override
    public void reconnectSocketHandler(PinpointClientHandler pinpointClientHandler) {
        Objects.requireNonNull(pinpointClientHandler, "pinpointClientHandler");
        if (this.closed) {
            this.logger.warn("reconnectClientHandler(). pinpointClientHandler force close.");
            pinpointClientHandler.close();
            return;
        }
        this.logger.warn("reconnectClientHandler:{}", (Object)pinpointClientHandler);
        this.pinpointClientHandler = pinpointClientHandler;
        this.notifyReconnectEvent();
    }

    @Override
    public boolean addPinpointClientReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        return this.reconnectEventListeners.add(eventListener);
    }

    @Override
    public boolean removePinpointClientReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        return this.reconnectEventListeners.remove(eventListener);
    }

    private void notifyReconnectEvent() {
        for (PinpointClientReconnectEventListener eachListener : this.reconnectEventListeners) {
            eachListener.reconnectPerformed(this);
        }
    }

    @Override
    public void sendSync(byte[] bytes) {
        this.ensureOpen();
        this.pinpointClientHandler.sendSync(bytes);
    }

    @Override
    public Future<?> sendAsync(byte[] bytes) {
        this.ensureOpen();
        return this.pinpointClientHandler.sendAsync(bytes);
    }

    @Override
    public void send(byte[] bytes) {
        this.ensureOpen();
        this.pinpointClientHandler.send(bytes);
    }

    @Override
    public Future<ResponseMessage> request(byte[] bytes) {
        if (this.pinpointClientHandler == null) {
            return this.returnFailureFuture();
        }
        return this.pinpointClientHandler.request(bytes);
    }

    @Override
    public void response(int requestId, byte[] payload) {
        this.ensureOpen();
        this.pinpointClientHandler.response(requestId, payload);
    }

    @Override
    public ClientStreamChannel openStream(byte[] payload, ClientStreamChannelEventHandler streamChannelEventHandler) throws StreamException {
        this.ensureOpen();
        return this.pinpointClientHandler.openStream(payload, streamChannelEventHandler);
    }

    @Override
    public ClientStreamChannel openStreamAndAwait(byte[] payload, ClientStreamChannelEventHandler streamChannelEventHandler, long timeout) throws StreamException {
        this.ensureOpen();
        return this.pinpointClientHandler.openStreamAndAwait(payload, streamChannelEventHandler, timeout);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.pinpointClientHandler.getRemoteAddress();
    }

    @Override
    public ClusterOption getLocalClusterOption() {
        return this.pinpointClientHandler.getLocalClusterOption();
    }

    @Override
    public ClusterOption getRemoteClusterOption() {
        return this.pinpointClientHandler.getRemoteClusterOption();
    }

    private Future<ResponseMessage> returnFailureFuture() {
        DefaultFuture<ResponseMessage> future = new DefaultFuture<ResponseMessage>();
        future.setFailure(new PinpointSocketException("pinpointClientHandler is null"));
        return future;
    }

    private void ensureOpen() {
        if (this.pinpointClientHandler == null) {
            throw new PinpointSocketException("pinpointClientHandler is null");
        }
    }

    @Override
    public void sendPing() {
        PinpointClientHandler pinpointClientHandler = this.pinpointClientHandler;
        if (pinpointClientHandler == null) {
            return;
        }
        pinpointClientHandler.sendPing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DefaultPinpointClient defaultPinpointClient = this;
        synchronized (defaultPinpointClient) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        PinpointClientHandler pinpointClientHandler = this.pinpointClientHandler;
        if (pinpointClientHandler == null) {
            return;
        }
        pinpointClientHandler.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isConnected() {
        return this.pinpointClientHandler.isConnected();
    }
}

