/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.Assert;

public class ClientOption {
    static final long DEFAULT_PING_DELAY = 300000L;
    static final long DEFAULT_ENABLE_WORKER_PACKET_DELAY = 60000L;
    static final long DEFAULT_WRITE_TIMEOUT_MILLIS = 3000L;
    static final long DEFAULT_REQUEST_TIMEOUT_MILLIS = 3000L;
    private final long reconnectDelay;
    private final long pingDelay;
    private final long enableWorkerPacketDelay;
    private final long writeTimeoutMillis;
    private final long requestTimeoutMillis;

    private ClientOption(long reconnectDelay, long pingDelay, long enableWorkerPacketDelay, long writeTimeoutMillis, long requestTimeoutMillis) {
        this.reconnectDelay = reconnectDelay;
        this.pingDelay = pingDelay;
        this.enableWorkerPacketDelay = enableWorkerPacketDelay;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.requestTimeoutMillis = requestTimeoutMillis;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public long getPingDelay() {
        return this.pingDelay;
    }

    public long getEnableWorkerPacketDelay() {
        return this.enableWorkerPacketDelay;
    }

    public long getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public String toString() {
        return "ClientOption{reconnectDelay=" + this.reconnectDelay + ", pingDelay=" + this.pingDelay + ", enableWorkerPacketDelay=" + this.enableWorkerPacketDelay + ", writeTimeoutMillis=" + this.writeTimeoutMillis + ", requestTimeoutMillis=" + this.requestTimeoutMillis + '}';
    }

    public static class Builder {
        private long reconnectDelay = 3000L;
        private long pingDelay = 300000L;
        private long enableWorkerPacketDelay = 60000L;
        private long writeTimeoutMillis = 3000L;
        private long requestTimeoutMillis = 3000L;

        public long getReconnectDelay() {
            return this.reconnectDelay;
        }

        public void setReconnectDelay(long reconnectDelay) {
            if (reconnectDelay < 0L) {
                throw new IllegalArgumentException("reconnectDelay cannot be a negative number");
            }
            this.reconnectDelay = reconnectDelay;
        }

        public long getPingDelay() {
            return this.pingDelay;
        }

        public void setPingDelay(long pingDelay) {
            if (pingDelay < 0L) {
                throw new IllegalArgumentException("pingDelay cannot be a negative number");
            }
            this.pingDelay = pingDelay;
        }

        public long getEnableWorkerPacketDelay() {
            return this.enableWorkerPacketDelay;
        }

        public void setEnableWorkerPacketDelay(long enableWorkerPacketDelay) {
            this.enableWorkerPacketDelay = enableWorkerPacketDelay;
        }

        public long getWriteTimeoutMillis() {
            return this.writeTimeoutMillis;
        }

        public void setWriteTimeoutMillis(long writeTimeoutMillis) {
            Assert.isTrue((writeTimeoutMillis >= 0L ? 1 : 0) != 0, (String)"writeTimeoutMillis cannot be a negative number");
            this.writeTimeoutMillis = writeTimeoutMillis;
        }

        public long getRequestTimeoutMillis() {
            return this.requestTimeoutMillis;
        }

        public void setRequestTimeoutMillis(long requestTimeoutMillis) {
            Assert.isTrue((requestTimeoutMillis >= 0L ? 1 : 0) != 0, (String)"requestTimeoutMillis cannot be a negative number");
            this.requestTimeoutMillis = requestTimeoutMillis;
        }

        public ClientOption build() {
            return new ClientOption(this.reconnectDelay, this.pingDelay, this.enableWorkerPacketDelay, this.writeTimeoutMillis, this.requestTimeoutMillis);
        }
    }
}

