/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive.protocol;

import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.receive.ManufacturerProtocol;
import org.apache.eventmesh.webhook.receive.WebHookRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubProtocol
implements ManufacturerProtocol {
    private static final String MANU_FACTURER_NAME = "github";
    private static final String FROM_SIGNATURE = "x-hub-signature-256";
    private static final String MANU_FACTURER_EVENT_ID = "x-github-delivery";
    private static final String HASH = "sha256=";
    private static final String H_MAC_SHA = "HmacSHA256";
    private static final char ZERO_CHAR = '0';
    public Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getManufacturerName() {
        return MANU_FACTURER_NAME;
    }

    @Override
    public void execute(WebHookRequest webHookRequest, WebHookConfig webHookConfig, Map<String, String> header) throws Exception {
        String fromSignature = header.get(FROM_SIGNATURE);
        if (!this.isValid(fromSignature, webHookRequest.getData(), webHookConfig.getSecret()).booleanValue()) {
            throw new Exception("webhook-GithubProtocol authenticate failed");
        }
        try {
            webHookRequest.setManufacturerEventId(header.get(MANU_FACTURER_EVENT_ID));
            webHookRequest.setManufacturerEventName(webHookConfig.getManufacturerEventName());
            webHookRequest.setManufacturerSource(this.getManufacturerName());
        }
        catch (Exception e) {
            throw new Exception("webhook-GithubProtocol parse failed", e);
        }
    }

    private Boolean isValid(String fromSignature, byte[] data, String secret) {
        String hash = HASH;
        try {
            Mac sha = Mac.getInstance(H_MAC_SHA);
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(Constants.DEFAULT_CHARSET), H_MAC_SHA);
            sha.init(secretKey);
            byte[] bytes = sha.doFinal(data);
            hash = hash + this.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            this.logger.error("Error HmacSHA256", (Throwable)e);
        }
        return hash.equals(fromSignature);
    }

    private String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }
}

