/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.cloudevents.resolver.tcp;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import io.cloudevents.core.v03.CloudEventBuilder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class TcpMessageProtocolResolver {
    public static CloudEvent buildEvent(Header header, String cloudEventJson) throws ProtocolHandleException {
        String protocolType = header.getProperty("protocoltype").toString();
        String protocolVersion = header.getProperty("protocolversion").toString();
        String protocolDesc = header.getProperty("protocoldesc").toString();
        if (StringUtils.isBlank((CharSequence)protocolType) || StringUtils.isBlank((CharSequence)protocolVersion) || StringUtils.isBlank((CharSequence)protocolDesc)) {
            throw new ProtocolHandleException(String.format("invalid protocol params protocolType %s|protocolVersion %s|protocolDesc %s", protocolType, protocolVersion, protocolDesc));
        }
        if (StringUtils.isBlank((CharSequence)cloudEventJson)) {
            throw new ProtocolHandleException(String.format("invalid method params cloudEventJson %s", cloudEventJson));
        }
        if (!StringUtils.equals((CharSequence)"cloudevents", (CharSequence)protocolType)) {
            throw new ProtocolHandleException(String.format("Unsupported protocolType: %s", protocolType));
        }
        if (StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion)) {
            EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");
            Preconditions.checkNotNull((Object)eventFormat, (Object)String.format("EventFormat: %s is not supported", "application/cloudevents+json"));
            CloudEvent event = eventFormat.deserialize(cloudEventJson.getBytes(StandardCharsets.UTF_8));
            io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v1((CloudEvent)event);
            for (String propKey : header.getProperties().keySet()) {
                cloudEventBuilder.withExtension(propKey, header.getProperty(propKey).toString());
            }
            return cloudEventBuilder.build();
        }
        if (StringUtils.equals((CharSequence)SpecVersion.V03.toString(), (CharSequence)protocolVersion)) {
            CloudEvent event = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json").deserialize(cloudEventJson.getBytes(StandardCharsets.UTF_8));
            CloudEventBuilder cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v03((CloudEvent)event);
            for (String propKey : header.getProperties().keySet()) {
                cloudEventBuilder.withExtension(propKey, header.getProperty(propKey).toString());
            }
            return cloudEventBuilder.build();
        }
        throw new ProtocolHandleException(String.format("Unsupported protocolVersion: %s", protocolVersion));
    }
}

