/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.cloudevents.resolver.grpc;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.grpc.common.SimpleMessageWrapper;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;

public class GrpcMessageProtocolResolver {
    public static CloudEvent buildEvent(SimpleMessage message) {
        String cloudEventJson = message.getContent();
        String contentType = message.getPropertiesOrDefault("contenttype", "application/cloudevents+json");
        EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat(contentType);
        CloudEvent event = Objects.requireNonNull(eventFormat).deserialize(cloudEventJson.getBytes(StandardCharsets.UTF_8));
        RequestHeader header = message.getHeader();
        String seqNum = GrpcMessageProtocolResolver.getMessageItemValue(message.getSeqNum(), event, "seqnum");
        String uniqueId = GrpcMessageProtocolResolver.getMessageItemValue(message.getUniqueId(), event, "uniqueid");
        String ttl = GrpcMessageProtocolResolver.getMessageItemValue(message.getTtl(), event, "ttl");
        String producerGroup = GrpcMessageProtocolResolver.getMessageItemValue(message.getProducerGroup(), event, "producergroup");
        String topic = (String)StringUtils.defaultIfEmpty((CharSequence)message.getTopic(), (CharSequence)event.getSubject());
        CloudEventBuilder eventBuilder = GrpcMessageProtocolResolver.builderCloudEventBuilder(header, event);
        eventBuilder.withSubject(topic).withExtension("seqnum", seqNum).withExtension("uniqueid", uniqueId).withExtension("producergroup", producerGroup).withExtension("ttl", ttl);
        message.getPropertiesMap().forEach((arg_0, arg_1) -> ((CloudEventBuilder)eventBuilder).withExtension(arg_0, arg_1));
        return eventBuilder.build();
    }

    public static SimpleMessageWrapper buildSimpleMessage(CloudEvent cloudEvent) {
        String env = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "env", "env");
        String idc = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "idc", "idc");
        String ip = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "ip", "127.0.0.1");
        String pid = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "pid", "123");
        String sys = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "sys", "sys123");
        String userName = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "username", "user");
        String passwd = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "passwd", "pass");
        String language = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "language", "JAVA");
        String protocol = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "protocoltype", "protocol");
        String protocolDesc = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "protocoldesc", "protocolDesc");
        String protocolVersion = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "protocolversion", "1.0");
        String seqNum = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "seqnum", "");
        String uniqueId = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "uniqueid", "");
        String producerGroup = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "producergroup", "producerGroup");
        String ttl = GrpcMessageProtocolResolver.getCloudEventExtension(cloudEvent, "ttl", "3000");
        RequestHeader header = RequestHeader.newBuilder().setEnv(env).setIdc(idc).setIp(ip).setPid(pid).setSys(sys).setUsername(userName).setPassword(passwd).setLanguage(language).setProtocolType(protocol).setProtocolDesc(protocolDesc).setProtocolVersion(protocolVersion).build();
        String contentType = Objects.requireNonNull(cloudEvent.getDataContentType());
        EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat(contentType);
        SimpleMessage.Builder messageBuilder = SimpleMessage.newBuilder().setHeader(header).setContent(new String(Objects.requireNonNull(eventFormat).serialize(cloudEvent), StandardCharsets.UTF_8)).setProducerGroup(producerGroup).setSeqNum(seqNum).setUniqueId(uniqueId).setTopic(cloudEvent.getSubject()).setTtl(ttl).putProperties("contenttype", contentType);
        for (String key : cloudEvent.getExtensionNames()) {
            messageBuilder.putProperties(key, Objects.requireNonNull(cloudEvent.getExtension(key)).toString());
        }
        return new SimpleMessageWrapper(messageBuilder.build());
    }

    private static String getCloudEventExtension(CloudEvent cloudEvent, String protocolKey, String defaultValue) {
        Object extension = cloudEvent.getExtension(protocolKey);
        return Objects.isNull(extension) ? defaultValue : extension.toString();
    }

    public static List<CloudEvent> buildBatchEvents(BatchMessage batchMessage) {
        ArrayList<CloudEvent> cloudEvents = new ArrayList<CloudEvent>();
        RequestHeader header = batchMessage.getHeader();
        for (BatchMessage.MessageItem item : batchMessage.getMessageItemList()) {
            String cloudEventJson = item.getContent();
            String contentType = item.getPropertiesOrDefault("contenttype", "application/cloudevents+json");
            EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat(contentType);
            CloudEvent event = Objects.requireNonNull(eventFormat).deserialize(cloudEventJson.getBytes(StandardCharsets.UTF_8));
            String env = StringUtils.isEmpty((CharSequence)header.getEnv()) ? GrpcMessageProtocolResolver.getEventExtension(event, "env") : header.getEnv();
            String idc = StringUtils.isEmpty((CharSequence)header.getIdc()) ? GrpcMessageProtocolResolver.getEventExtension(event, "idc") : header.getIdc();
            String ip = StringUtils.isEmpty((CharSequence)header.getIp()) ? GrpcMessageProtocolResolver.getEventExtension(event, "ip") : header.getIp();
            String pid = StringUtils.isEmpty((CharSequence)header.getPid()) ? GrpcMessageProtocolResolver.getEventExtension(event, "pid") : header.getPid();
            String sys = StringUtils.isEmpty((CharSequence)header.getSys()) ? GrpcMessageProtocolResolver.getEventExtension(event, "sys") : header.getSys();
            String language = StringUtils.isEmpty((CharSequence)header.getLanguage()) ? GrpcMessageProtocolResolver.getEventExtension(event, "language") : header.getLanguage();
            String protocolType = StringUtils.isEmpty((CharSequence)header.getProtocolType()) ? GrpcMessageProtocolResolver.getEventExtension(event, "protocoltype") : header.getProtocolType();
            String protocolDesc = StringUtils.isEmpty((CharSequence)header.getProtocolDesc()) ? GrpcMessageProtocolResolver.getEventExtension(event, "protocoldesc") : header.getProtocolDesc();
            String protocolVersion = StringUtils.isEmpty((CharSequence)header.getProtocolVersion()) ? GrpcMessageProtocolResolver.getEventExtension(event, "protocolversion") : header.getProtocolVersion();
            String username = StringUtils.isEmpty((CharSequence)header.getUsername()) ? GrpcMessageProtocolResolver.getEventExtension(event, "username") : header.getUsername();
            String passwd = StringUtils.isEmpty((CharSequence)header.getPassword()) ? GrpcMessageProtocolResolver.getEventExtension(event, "passwd") : header.getPassword();
            String seqNum = StringUtils.isEmpty((CharSequence)item.getSeqNum()) ? GrpcMessageProtocolResolver.getEventExtension(event, "seqnum") : item.getSeqNum();
            String uniqueId = StringUtils.isEmpty((CharSequence)item.getUniqueId()) ? GrpcMessageProtocolResolver.getEventExtension(event, "uniqueid") : item.getUniqueId();
            String topic = StringUtils.isEmpty((CharSequence)batchMessage.getTopic()) ? event.getSubject() : batchMessage.getTopic();
            String producerGroup = StringUtils.isEmpty((CharSequence)batchMessage.getProducerGroup()) ? GrpcMessageProtocolResolver.getEventExtension(event, "producergroup") : batchMessage.getProducerGroup();
            String ttl = StringUtils.isEmpty((CharSequence)item.getTtl()) ? GrpcMessageProtocolResolver.getEventExtension(event, "ttl") : item.getTtl();
            CloudEventBuilder eventBuilder = GrpcMessageProtocolResolver.builderCloudEventBuilder(header, event);
            eventBuilder.withSubject(topic).withExtension("seqnum", seqNum).withExtension("uniqueid", uniqueId).withExtension("producergroup", producerGroup).withExtension("ttl", ttl);
            item.getPropertiesMap().forEach((arg_0, arg_1) -> ((CloudEventBuilder)eventBuilder).withExtension(arg_0, arg_1));
            cloudEvents.add(eventBuilder.build());
        }
        return cloudEvents;
    }

    private static String getHeaderValue(String value, CloudEvent event, String key) {
        return StringUtils.isEmpty((CharSequence)value) ? Objects.requireNonNull(event.getExtension(key)).toString() : value;
    }

    private static String getMessageItemValue(String value, CloudEvent event, String key) {
        return StringUtils.isEmpty((CharSequence)value) ? Objects.requireNonNull(event.getExtension(key)).toString() : value;
    }

    private static CloudEventBuilder builderCloudEventBuilder(RequestHeader header, CloudEvent event) {
        String env = GrpcMessageProtocolResolver.getHeaderValue(header.getEnv(), event, "env");
        String idc = GrpcMessageProtocolResolver.getHeaderValue(header.getIdc(), event, "idc");
        String ip = GrpcMessageProtocolResolver.getHeaderValue(header.getIp(), event, "ip");
        String pid = GrpcMessageProtocolResolver.getHeaderValue(header.getPid(), event, "pid");
        String sys = GrpcMessageProtocolResolver.getHeaderValue(header.getSys(), event, "sys");
        String language = GrpcMessageProtocolResolver.getHeaderValue(header.getLanguage(), event, "language");
        String protocolType = GrpcMessageProtocolResolver.getHeaderValue(header.getProtocolType(), event, "protocoltype");
        String protocolDesc = GrpcMessageProtocolResolver.getHeaderValue(header.getProtocolDesc(), event, "protocoldesc");
        String protocolVersion = GrpcMessageProtocolResolver.getHeaderValue(header.getProtocolVersion(), event, "protocolversion");
        String username = GrpcMessageProtocolResolver.getHeaderValue(header.getUsername(), event, "username");
        String passwd = GrpcMessageProtocolResolver.getHeaderValue(header.getPassword(), event, "passwd");
        io.cloudevents.core.v1.CloudEventBuilder eventBuilder = StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion) ? CloudEventBuilder.v1((CloudEvent)event) : CloudEventBuilder.v03((CloudEvent)event);
        return eventBuilder.withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion);
    }

    private static String getEventExtension(CloudEvent event, String protocolKey) {
        return Objects.requireNonNull(event.getExtension(protocolKey)).toString();
    }

    private static String getEventExtension(CloudEvent event, String protocolKey, String defaultValue) {
        Object extension = event.getExtension(protocolKey);
        return Objects.isNull(extension) ? defaultValue : extension.toString();
    }
}

