/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.kafka.consumer;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.connector.kafka.consumer.ConsumerImpl;

public class KafkaConsumerImpl
implements Consumer {
    private ConsumerImpl consumer;

    public synchronized void init(Properties props) throws Exception {
        String consumerGroup = props.getProperty("consumerGroup");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("group.id", consumerGroup);
        this.consumer = new ConsumerImpl(props);
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        this.consumer.updateOffset(cloudEvents, context);
    }

    public void subscribe(String topic) throws Exception {
        this.consumer.subscribe(topic);
    }

    public boolean isStarted() {
        return this.consumer.isStarted();
    }

    public boolean isClosed() {
        return this.consumer.isClosed();
    }

    public synchronized void start() {
        this.consumer.start();
    }

    public void unsubscribe(String topic) {
        this.consumer.unsubscribe(topic);
    }

    public void registerEventListener(EventListener listener) {
        this.consumer.registerEventListener(listener);
    }

    public synchronized void shutdown() {
        this.consumer.shutdown();
    }
}

