/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.kafka.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationWrapper {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationWrapper.class);
    public static final Logger logger = LoggerFactory.getLogger(ConfigurationWrapper.class);
    private static final Properties properties = new Properties();

    public static String getProp(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : properties.getProperty(key, null);
    }

    private static void loadProperties() {
        block54: {
            try (InputStream resourceAsStream = ConfigurationWrapper.class.getResourceAsStream("/kafka-client.properties");){
                if (resourceAsStream != null) {
                    properties.load(resourceAsStream);
                }
            }
            catch (IOException e) {
                logger.error("Error while loading from classpath:", (Throwable)e);
                throw new RuntimeException(String.format("Load %s.properties file from classpath error", "kafka-client.properties"));
            }
            try {
                String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + "kafka-client.properties";
                if (!new File(configPath).exists()) break block54;
                try (FileInputStream fileInputStream = new FileInputStream(configPath);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader reader = new BufferedReader(inputStreamReader);){
                    properties.load(reader);
                }
            }
            catch (IOException e) {
                logger.error("Error while loading from conf home: ", (Throwable)e);
                throw new IllegalArgumentException(String.format("Cannot load %s file from conf", "kafka-client.properties"));
            }
        }
    }

    private ConfigurationWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ConfigurationWrapper.loadProperties();
    }
}

