/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.redis.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationWrapper {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationWrapper.class);
    private static final String CONF_FILE = "redis-client.properties";
    private static final Properties properties = new Properties();

    public static String getProperty(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : properties.getProperty(key, null);
    }

    public static Properties getPropertiesByPrefix(String prefix) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return null;
        }
        return PropertiesUtils.getPropertiesByPrefix((Properties)properties, (String)prefix);
    }

    private static void loadProperties() {
        try (InputStream resourceAsStream = ConfigurationWrapper.class.getResourceAsStream("/redis-client.properties");){
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            log.error(String.format("Load %s file from classpath error", CONF_FILE), (Throwable)e);
            throw new RuntimeException(String.format("Load %s file from classpath error", CONF_FILE));
        }
        try {
            String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + CONF_FILE;
            PropertiesUtils.loadPropertiesWhenFileExist((Properties)properties, (String)configPath);
        }
        catch (IOException e) {
            log.error(String.format("Cannot load %s file from conf", CONF_FILE), (Throwable)e);
            throw new IllegalArgumentException(String.format("Cannot load %s file from conf", CONF_FILE));
        }
    }

    static {
        ConfigurationWrapper.loadProperties();
    }
}

