/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl.eventmeshmessage;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.tcp.EventMeshTCPSubClient;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.common.RequestContext;
import org.apache.eventmesh.client.tcp.common.TcpClient;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.client.tcp.impl.AbstractEventMeshTCPSubHandler;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventMeshMessageTCPSubClient
extends TcpClient
implements EventMeshTCPSubClient<EventMeshMessage> {
    private static final Logger log = LoggerFactory.getLogger(EventMeshMessageTCPSubClient.class);
    private final List<SubscriptionItem> subscriptionItems = Collections.synchronizedList(new LinkedList());
    private ReceiveMsgHook<EventMeshMessage> callback;

    public EventMeshMessageTCPSubClient(EventMeshTCPClientConfig eventMeshTcpClientConfig) {
        super(eventMeshTcpClientConfig);
    }

    @Override
    public void init() throws EventMeshException {
        try {
            this.open(new EventMeshMessageTCPSubHandler(this.contexts));
            this.hello();
            this.heartbeat();
            log.info("SimpleSubClientImpl|{}|started!", (Object)CLIENTNO);
        }
        catch (Exception ex) {
            throw new EventMeshException("Initialize EventMeshMessageTcpSubClient error", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws EventMeshException {
        try {
            super.reconnect();
            this.hello();
            if (!CollectionUtils.isEmpty(this.subscriptionItems)) {
                List<SubscriptionItem> list = this.subscriptionItems;
                synchronized (list) {
                    for (SubscriptionItem item : this.subscriptionItems) {
                        Package request = MessageUtils.subscribe(item.getTopic(), item.getMode(), item.getType());
                        this.io(request, 20000L);
                    }
                }
            }
            this.listen();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void subscribe(String topic, SubscriptionMode subscriptionMode, SubscriptionType subscriptionType) throws EventMeshException {
        try {
            this.subscriptionItems.add(new SubscriptionItem(topic, subscriptionMode, subscriptionType));
            Package request = MessageUtils.subscribe(topic, subscriptionMode, subscriptionType);
            this.io(request, 20000L);
        }
        catch (Exception ex) {
            throw new EventMeshException("Subscribe error", (Throwable)ex);
        }
    }

    @Override
    public void unsubscribe() throws EventMeshException {
        try {
            Package request = MessageUtils.unsubscribe();
            this.io(request, 20000L);
        }
        catch (Exception ex) {
            throw new EventMeshException("Unsubscribe error", (Throwable)ex);
        }
    }

    @Override
    public void listen() throws EventMeshException {
        try {
            Package request = MessageUtils.listen();
            this.io(request, 20000L);
        }
        catch (Exception ex) {
            throw new EventMeshException("Listen error", (Throwable)ex);
        }
    }

    @Override
    public void registerBusiHandler(ReceiveMsgHook<EventMeshMessage> receiveMsgHook) throws EventMeshException {
        this.callback = receiveMsgHook;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception ex) {
            log.error("exception occurred when close.", (Throwable)ex);
        }
    }

    private class EventMeshMessageTCPSubHandler
    extends AbstractEventMeshTCPSubHandler<EventMeshMessage> {
        public EventMeshMessageTCPSubHandler(ConcurrentHashMap<Object, RequestContext> contexts) {
            super(contexts);
        }

        @Override
        public EventMeshMessage getProtocolMessage(Package tcpPackage) {
            return (EventMeshMessage)JsonUtils.deserialize((String)tcpPackage.getBody().toString(), EventMeshMessage.class);
        }

        @Override
        public void callback(EventMeshMessage eventMeshMessage, ChannelHandlerContext ctx) {
            if (EventMeshMessageTCPSubClient.this.callback != null) {
                EventMeshMessageTCPSubClient.this.callback.handle(eventMeshMessage).ifPresent(responseMessage -> ctx.writeAndFlush((Object)MessageUtils.buildPackage(responseMessage, Command.RESPONSE_TO_SERVER)));
            }
        }

        @Override
        public void response(Package tcpPackage) {
            try {
                EventMeshMessageTCPSubClient.this.send(tcpPackage);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

