/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import com.google.common.base.Preconditions;
import io.netty.handler.codec.http.HttpMethod;
import io.openmessaging.api.Message;
import org.apache.eventmesh.client.http.AbstractProducerHttpClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenMessageProducer
extends AbstractProducerHttpClient<Message> {
    private static final Logger log = LoggerFactory.getLogger(OpenMessageProducer.class);

    public OpenMessageProducer(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        super(eventMeshHttpClientConfig);
    }

    @Override
    public RequestParam builderPublishRequestParam(Message openMessage) {
        return this.buildCommonPostParam(openMessage).addHeader("code", RequestCode.MSG_SEND_ASYNC.getRequestCode());
    }

    @Override
    public RequestParam builderRequestParam(Message message, long timeout) {
        return this.buildCommonPostParam(message).addHeader("code", RequestCode.MSG_SEND_SYNC.getRequestCode()).setTimeout(timeout);
    }

    @Override
    public void validateMessage(Message message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
    }

    private RequestParam buildCommonPostParam(Message openMessage) {
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("username", this.eventMeshHttpClientConfig.getUserName()).addHeader("passwd", this.eventMeshHttpClientConfig.getPassword()).addHeader("language", "JAVA").addHeader("protocoltype", "openmessage").addHeader("protocoldesc", "http").addBody("producergroup", this.eventMeshHttpClientConfig.getProducerGroup()).addBody("content", JsonUtils.serialize((Object)openMessage));
        return requestParam;
    }

    @Override
    public Message transformMessage(EventMeshRetObj retObj) {
        SendMessageResponseBody.ReplyMessage replyMessage = (SendMessageResponseBody.ReplyMessage)JsonUtils.deserialize((String)retObj.getRetMsg(), SendMessageResponseBody.ReplyMessage.class);
        return null;
    }
}

