/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import com.google.common.base.Preconditions;
import io.cloudevents.SpecVersion;
import io.netty.handler.codec.http.HttpMethod;
import org.apache.eventmesh.client.http.AbstractProducerHttpClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventMeshMessageProducer
extends AbstractProducerHttpClient<EventMeshMessage> {
    private static final Logger log = LoggerFactory.getLogger(EventMeshMessageProducer.class);

    public EventMeshMessageProducer(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        super(eventMeshHttpClientConfig);
    }

    @Override
    public RequestParam builderPublishRequestParam(EventMeshMessage message) {
        return this.buildCommonPostParam(message).addHeader("code", RequestCode.MSG_SEND_ASYNC.getRequestCode());
    }

    @Override
    public RequestParam builderRequestParam(EventMeshMessage message, long timeout) {
        return this.buildCommonPostParam(message).addHeader("code", RequestCode.MSG_SEND_SYNC.getRequestCode()).setTimeout(timeout);
    }

    @Override
    public void validateMessage(EventMeshMessage message) {
        Preconditions.checkNotNull((Object)message, (Object)"eventMeshMessage invalid");
        Preconditions.checkNotNull((Object)message.getTopic(), (Object)"eventMeshMessage[topic] invalid");
        Preconditions.checkNotNull((Object)message.getContent(), (Object)"eventMeshMessage[content] invalid");
    }

    private void validateEventMeshMessage(EventMeshMessage message) {
        Preconditions.checkNotNull((Object)message, (Object)"eventMeshMessage invalid");
        Preconditions.checkNotNull((Object)message.getTopic(), (Object)"eventMeshMessage[topic] invalid");
        Preconditions.checkNotNull((Object)message.getContent(), (Object)"eventMeshMessage[content] invalid");
    }

    private RequestParam buildCommonPostParam(EventMeshMessage message) {
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("env", this.eventMeshHttpClientConfig.getEnv()).addHeader("idc", this.eventMeshHttpClientConfig.getIdc()).addHeader("ip", this.eventMeshHttpClientConfig.getIp()).addHeader("pid", this.eventMeshHttpClientConfig.getPid()).addHeader("sys", this.eventMeshHttpClientConfig.getSys()).addHeader("username", this.eventMeshHttpClientConfig.getUserName()).addHeader("passwd", this.eventMeshHttpClientConfig.getPassword()).addHeader("version", ProtocolVersion.V1.getVersion()).addHeader("protocoltype", "eventmeshmessage").addHeader("protocoldesc", "http").addHeader("protocolversion", SpecVersion.V1.toString()).addHeader("language", "JAVA").addBody("producergroup", this.eventMeshHttpClientConfig.getProducerGroup()).addBody("topic", message.getTopic()).addBody("content", message.getContent()).addBody("ttl", message.getProp("ttl")).addBody("bizseqno", message.getBizSeqNo()).addBody("uniqueid", message.getUniqueId());
        return requestParam;
    }

    @Override
    public EventMeshMessage transformMessage(EventMeshRetObj retObj) {
        SendMessageResponseBody.ReplyMessage replyMessage = (SendMessageResponseBody.ReplyMessage)JsonUtils.deserialize((String)retObj.getRetMsg(), SendMessageResponseBody.ReplyMessage.class);
        return EventMeshMessage.builder().content(replyMessage.body).prop(replyMessage.properties).topic(replyMessage.topic).build();
    }
}

