/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.provider.EventFormatProvider;
import io.netty.handler.codec.http.HttpMethod;
import java.nio.charset.StandardCharsets;
import org.apache.eventmesh.client.http.AbstractProducerHttpClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloudEventProducer
extends AbstractProducerHttpClient<CloudEvent> {
    private static final Logger log = LoggerFactory.getLogger(CloudEventProducer.class);

    public CloudEventProducer(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        super(eventMeshHttpClientConfig);
    }

    @Override
    public RequestParam builderPublishRequestParam(CloudEvent cloudEvent) {
        CloudEvent enhanceCloudEvent = this.enhanceCloudEvent(cloudEvent);
        return this.buildCommonPostParam(enhanceCloudEvent).addHeader("code", RequestCode.MSG_SEND_ASYNC.getRequestCode());
    }

    @Override
    public RequestParam builderRequestParam(CloudEvent cloudEvent, long timeout) {
        CloudEvent enhanceCloudEvent = this.enhanceCloudEvent(cloudEvent);
        return this.buildCommonPostParam(enhanceCloudEvent).addHeader("code", RequestCode.MSG_SEND_SYNC.getRequestCode()).setTimeout(timeout);
    }

    @Override
    public void validateMessage(CloudEvent cloudEvent) {
        Preconditions.checkNotNull((Object)cloudEvent, (Object)"CloudEvent cannot be null");
    }

    private void validateCloudEvent(CloudEvent cloudEvent) {
        Preconditions.checkNotNull((Object)cloudEvent, (Object)"CloudEvent cannot be null");
    }

    private RequestParam buildCommonPostParam(CloudEvent cloudEvent) {
        this.validateCloudEvent(cloudEvent);
        byte[] bodyByte = EventFormatProvider.getInstance().resolveFormat(cloudEvent.getDataContentType()).serialize(cloudEvent);
        String content = new String(bodyByte, StandardCharsets.UTF_8);
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("env", this.eventMeshHttpClientConfig.getEnv()).addHeader("idc", this.eventMeshHttpClientConfig.getIdc()).addHeader("ip", this.eventMeshHttpClientConfig.getIp()).addHeader("pid", this.eventMeshHttpClientConfig.getPid()).addHeader("sys", this.eventMeshHttpClientConfig.getSys()).addHeader("username", this.eventMeshHttpClientConfig.getUserName()).addHeader("passwd", this.eventMeshHttpClientConfig.getPassword()).addHeader("language", "JAVA").addHeader("protocoltype", "cloudevents").addHeader("protocoldesc", "http").addHeader("protocolversion", cloudEvent.getSpecVersion().toString()).addBody("producergroup", this.eventMeshHttpClientConfig.getProducerGroup()).addBody("content", content);
        return requestParam;
    }

    private CloudEvent enhanceCloudEvent(CloudEvent cloudEvent) {
        return CloudEventBuilder.from((CloudEvent)cloudEvent).withExtension("env", this.eventMeshHttpClientConfig.getEnv()).withExtension("idc", this.eventMeshHttpClientConfig.getIdc()).withExtension("ip", this.eventMeshHttpClientConfig.getIp()).withExtension("pid", this.eventMeshHttpClientConfig.getPid()).withExtension("sys", this.eventMeshHttpClientConfig.getSys()).withExtension("language", "JAVA").withExtension("protocoldesc", cloudEvent.getSpecVersion().name()).withExtension("protocolversion", cloudEvent.getSpecVersion().toString()).withExtension("bizseqno", RandomStringUtils.generateNum((int)30)).withExtension("uniqueid", RandomStringUtils.generateNum((int)30)).build();
    }

    @Override
    public CloudEvent transformMessage(EventMeshRetObj retObj) {
        SendMessageResponseBody.ReplyMessage replyMessage = (SendMessageResponseBody.ReplyMessage)JsonUtils.deserialize((String)retObj.getRetMsg(), SendMessageResponseBody.ReplyMessage.class);
        return null;
    }
}

