/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.grpc;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcProfilerStreamSocket;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcStreamService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Timer timer;
    private final long flushDelay;
    private final Object lock = new Object();
    private final AtomicReference<TimerTask> currentTaskReference = new AtomicReference();
    private final List<GrpcProfilerStreamSocket<?>> grpcProfilerStreamSocketList = new CopyOnWriteArrayList();

    public GrpcStreamService(String name, long flushDelay) {
        Objects.requireNonNull(name, "name");
        Assert.isTrue((flushDelay > 0L ? 1 : 0) != 0, (String)"flushDelay must be >= 0");
        this.timer = new Timer("Pinpoint-Grpc-" + name + "-Timer", true);
        this.flushDelay = flushDelay;
    }

    public GrpcProfilerStreamSocket<?>[] getStreamSocketList() {
        return this.grpcProfilerStreamSocketList.toArray(new GrpcProfilerStreamSocket[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(GrpcProfilerStreamSocket<?> streamSocket, TimerTask timerTask) {
        Object object = this.lock;
        synchronized (object) {
            this.grpcProfilerStreamSocketList.add(streamSocket);
            boolean turnOn = this.currentTaskReference.compareAndSet(null, timerTask);
            if (turnOn) {
                this.logger.info("turn on TimerTask.");
                this.timer.scheduleAtFixedRate(timerTask, 0L, this.flushDelay);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(GrpcProfilerStreamSocket<?> streamSocket) {
        Object object = this.lock;
        synchronized (object) {
            this.grpcProfilerStreamSocketList.remove(streamSocket);
            if (this.grpcProfilerStreamSocketList.isEmpty()) {
                TimerTask activeThreadCountTimerTask = this.currentTaskReference.get();
                if (activeThreadCountTimerTask != null) {
                    this.currentTaskReference.compareAndSet(activeThreadCountTimerTask, null);
                    activeThreadCountTimerTask.cancel();
                    this.logger.info("turn off TimerTask.");
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            GrpcProfilerStreamSocket[] streamSockets;
            if (this.timer != null) {
                this.timer.cancel();
            }
            for (GrpcProfilerStreamSocket streamSocket : streamSockets = this.grpcProfilerStreamSocketList.toArray(new GrpcProfilerStreamSocket[0])) {
                if (streamSocket == null) continue;
                streamSocket.close();
            }
            this.grpcProfilerStreamSocketList.clear();
        }
    }
}

